/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.organizations.model.Child;
import software.amazon.awssdk.services.organizations.model.ChildrenCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListChildrenResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListChildrenResponse> {
    private final List<Child> children;
    private final String nextToken;

    private ListChildrenResponse(BuilderImpl builder) {
        this.children = builder.children;
        this.nextToken = builder.nextToken;
    }

    public List<Child> children() {
        return this.children;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.children() == null ? 0 : this.children().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChildrenResponse)) {
            return false;
        }
        ListChildrenResponse other = (ListChildrenResponse)((Object)obj);
        if (other.children() == null ^ this.children() == null) {
            return false;
        }
        if (other.children() != null && !other.children().equals(this.children())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.children() != null) {
            sb.append("Children: ").append(this.children()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Child> children;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChildrenResponse model) {
            this.setChildren(model.children);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Child> getChildren() {
            return this.children;
        }

        @Override
        public final Builder children(Collection<Child> children) {
            this.children = ChildrenCopier.copy(children);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder children(Child ... children) {
            if (this.children == null) {
                this.children = new ArrayList<Child>(children.length);
            }
            for (Child e : children) {
                this.children.add(e);
            }
            return this;
        }

        public final void setChildren(Collection<Child> children) {
            this.children = ChildrenCopier.copy(children);
        }

        @SafeVarargs
        public final void setChildren(Child ... children) {
            if (this.children == null) {
                this.children = new ArrayList<Child>(children.length);
            }
            for (Child e : children) {
                this.children.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListChildrenResponse build() {
            return new ListChildrenResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListChildrenResponse> {
        public Builder children(Collection<Child> var1);

        public Builder children(Child ... var1);

        public Builder nextToken(String var1);
    }
}

