/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason;
import software.amazon.awssdk.services.organizations.model.CreateAccountState;
import software.amazon.awssdk.services.organizations.transform.CreateAccountStatusMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateAccountStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, CreateAccountStatus> {
    private final String id;
    private final String accountName;
    private final String state;
    private final Date requestedTimestamp;
    private final Date completedTimestamp;
    private final String accountId;
    private final String failureReason;

    private CreateAccountStatus(BuilderImpl builder) {
        this.id = builder.id;
        this.accountName = builder.accountName;
        this.state = builder.state;
        this.requestedTimestamp = builder.requestedTimestamp;
        this.completedTimestamp = builder.completedTimestamp;
        this.accountId = builder.accountId;
        this.failureReason = builder.failureReason;
    }

    public String id() {
        return this.id;
    }

    public String accountName() {
        return this.accountName;
    }

    public String state() {
        return this.state;
    }

    public Date requestedTimestamp() {
        return this.requestedTimestamp;
    }

    public Date completedTimestamp() {
        return this.completedTimestamp;
    }

    public String accountId() {
        return this.accountId;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.accountName() == null ? 0 : this.accountName().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.requestedTimestamp() == null ? 0 : this.requestedTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.completedTimestamp() == null ? 0 : this.completedTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.accountId() == null ? 0 : this.accountId().hashCode());
        hashCode = 31 * hashCode + (this.failureReason() == null ? 0 : this.failureReason().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccountStatus)) {
            return false;
        }
        CreateAccountStatus other = (CreateAccountStatus)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.accountName() == null ^ this.accountName() == null) {
            return false;
        }
        if (other.accountName() != null && !other.accountName().equals(this.accountName())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.requestedTimestamp() == null ^ this.requestedTimestamp() == null) {
            return false;
        }
        if (other.requestedTimestamp() != null && !other.requestedTimestamp().equals(this.requestedTimestamp())) {
            return false;
        }
        if (other.completedTimestamp() == null ^ this.completedTimestamp() == null) {
            return false;
        }
        if (other.completedTimestamp() != null && !other.completedTimestamp().equals(this.completedTimestamp())) {
            return false;
        }
        if (other.accountId() == null ^ this.accountId() == null) {
            return false;
        }
        if (other.accountId() != null && !other.accountId().equals(this.accountId())) {
            return false;
        }
        if (other.failureReason() == null ^ this.failureReason() == null) {
            return false;
        }
        return other.failureReason() == null || other.failureReason().equals(this.failureReason());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.accountName() != null) {
            sb.append("AccountName: ").append(this.accountName()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.requestedTimestamp() != null) {
            sb.append("RequestedTimestamp: ").append(this.requestedTimestamp()).append(",");
        }
        if (this.completedTimestamp() != null) {
            sb.append("CompletedTimestamp: ").append(this.completedTimestamp()).append(",");
        }
        if (this.accountId() != null) {
            sb.append("AccountId: ").append(this.accountId()).append(",");
        }
        if (this.failureReason() != null) {
            sb.append("FailureReason: ").append(this.failureReason()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CreateAccountStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private String accountName;
        private String state;
        private Date requestedTimestamp;
        private Date completedTimestamp;
        private String accountId;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccountStatus model) {
            this.setId(model.id);
            this.setAccountName(model.accountName);
            this.setState(model.state);
            this.setRequestedTimestamp(model.requestedTimestamp);
            this.setCompletedTimestamp(model.completedTimestamp);
            this.setAccountId(model.accountId);
            this.setFailureReason(model.failureReason);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getAccountName() {
            return this.accountName;
        }

        @Override
        public final Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public final void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CreateAccountState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final void setState(CreateAccountState state) {
            this.state(state.toString());
        }

        public final Date getRequestedTimestamp() {
            return this.requestedTimestamp;
        }

        @Override
        public final Builder requestedTimestamp(Date requestedTimestamp) {
            this.requestedTimestamp = StandardMemberCopier.copy((Date)requestedTimestamp);
            return this;
        }

        public final void setRequestedTimestamp(Date requestedTimestamp) {
            this.requestedTimestamp = StandardMemberCopier.copy((Date)requestedTimestamp);
        }

        public final Date getCompletedTimestamp() {
            return this.completedTimestamp;
        }

        @Override
        public final Builder completedTimestamp(Date completedTimestamp) {
            this.completedTimestamp = StandardMemberCopier.copy((Date)completedTimestamp);
            return this;
        }

        public final void setCompletedTimestamp(Date completedTimestamp) {
            this.completedTimestamp = StandardMemberCopier.copy((Date)completedTimestamp);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public final Builder failureReason(CreateAccountFailureReason failureReason) {
            this.failureReason(failureReason.toString());
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final void setFailureReason(CreateAccountFailureReason failureReason) {
            this.failureReason(failureReason.toString());
        }

        public CreateAccountStatus build() {
            return new CreateAccountStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateAccountStatus> {
        public Builder id(String var1);

        public Builder accountName(String var1);

        public Builder state(String var1);

        public Builder state(CreateAccountState var1);

        public Builder requestedTimestamp(Date var1);

        public Builder completedTimestamp(Date var1);

        public Builder accountId(String var1);

        public Builder failureReason(String var1);

        public Builder failureReason(CreateAccountFailureReason var1);
    }
}

