/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.opsworkscm.OpsWorksCmClient;
import software.amazon.awssdk.services.opsworkscm.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.opsworkscm.model.DescribeNodeAssociationStatusRequest;
import software.amazon.awssdk.services.opsworkscm.model.DescribeNodeAssociationStatusResponse;
import software.amazon.awssdk.services.opsworkscm.model.OpsWorksCmRequest;
import software.amazon.awssdk.services.opsworkscm.waiters.OpsWorksCmWaiter;
import software.amazon.awssdk.services.opsworkscm.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultOpsWorksCmWaiter
implements OpsWorksCmWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final OpsWorksCmClient client;
    private final AttributeMap managedResources;
    private final Waiter<DescribeNodeAssociationStatusResponse> nodeAssociatedWaiter;

    private DefaultOpsWorksCmWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (OpsWorksCmClient)OpsWorksCmClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.nodeAssociatedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeNodeAssociationStatusResponse.class).acceptors(DefaultOpsWorksCmWaiter.nodeAssociatedWaiterAcceptors())).overrideConfiguration(DefaultOpsWorksCmWaiter.nodeAssociatedWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeNodeAssociationStatusResponse> waitUntilNodeAssociated(DescribeNodeAssociationStatusRequest describeNodeAssociationStatusRequest) {
        return this.nodeAssociatedWaiter.run(() -> this.client.describeNodeAssociationStatus(this.applyWaitersUserAgent(describeNodeAssociationStatusRequest)));
    }

    @Override
    public WaiterResponse<DescribeNodeAssociationStatusResponse> waitUntilNodeAssociated(DescribeNodeAssociationStatusRequest describeNodeAssociationStatusRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.nodeAssociatedWaiter.run(() -> this.client.describeNodeAssociationStatus(this.applyWaitersUserAgent(describeNodeAssociationStatusRequest)), DefaultOpsWorksCmWaiter.nodeAssociatedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeNodeAssociationStatusResponse>> nodeAssociatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeNodeAssociationStatusResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeNodeAssociationStatusResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("NodeAssociationStatus").value(), "SUCCESS");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("NodeAssociationStatus").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (NodeAssociationStatus=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration nodeAssociatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(15);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static OpsWorksCmWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends OpsWorksCmRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((OpsWorksCmRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements OpsWorksCmWaiter.Builder {
        private OpsWorksCmClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public OpsWorksCmWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public OpsWorksCmWaiter.Builder client(OpsWorksCmClient client) {
            this.client = client;
            return this;
        }

        @Override
        public OpsWorksCmWaiter build() {
            return new DefaultOpsWorksCmWaiter(this);
        }
    }
}

