/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworkscm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An event that is related to the server, such as the start of maintenance or backup.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServerEvent implements SdkPojo, Serializable, ToCopyableBuilder<ServerEvent.Builder, ServerEvent> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ServerEvent::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServerEvent::serverName)).setter(setter(Builder::serverName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServerEvent::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> LOG_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServerEvent::logUrl)).setter(setter(Builder::logUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            SERVER_NAME_FIELD, MESSAGE_FIELD, LOG_URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final String serverName;

    private final String message;

    private final String logUrl;

    private ServerEvent(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.serverName = builder.serverName;
        this.message = builder.message;
        this.logUrl = builder.logUrl;
    }

    /**
     * <p>
     * The time when the event occurred.
     * </p>
     * 
     * @return The time when the event occurred.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The name of the server on or for which the event occurred.
     * </p>
     * 
     * @return The name of the server on or for which the event occurred.
     */
    public String serverName() {
        return serverName;
    }

    /**
     * <p>
     * A human-readable informational or status message.
     * </p>
     * 
     * @return A human-readable informational or status message.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * The Amazon S3 URL of the event's log file.
     * </p>
     * 
     * @return The Amazon S3 URL of the event's log file.
     */
    public String logUrl() {
        return logUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(serverName());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(logUrl());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerEvent)) {
            return false;
        }
        ServerEvent other = (ServerEvent) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(serverName(), other.serverName())
                && Objects.equals(message(), other.message()) && Objects.equals(logUrl(), other.logUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ServerEvent").add("CreatedAt", createdAt()).add("ServerName", serverName())
                .add("Message", message()).add("LogUrl", logUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "ServerName":
            return Optional.ofNullable(clazz.cast(serverName()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "LogUrl":
            return Optional.ofNullable(clazz.cast(logUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServerEvent, T> g) {
        return obj -> g.apply((ServerEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServerEvent> {
        /**
         * <p>
         * The time when the event occurred.
         * </p>
         * 
         * @param createdAt
         *        The time when the event occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The name of the server on or for which the event occurred.
         * </p>
         * 
         * @param serverName
         *        The name of the server on or for which the event occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverName(String serverName);

        /**
         * <p>
         * A human-readable informational or status message.
         * </p>
         * 
         * @param message
         *        A human-readable informational or status message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The Amazon S3 URL of the event's log file.
         * </p>
         * 
         * @param logUrl
         *        The Amazon S3 URL of the event's log file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logUrl(String logUrl);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private String serverName;

        private String message;

        private String logUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerEvent model) {
            createdAt(model.createdAt);
            serverName(model.serverName);
            message(model.message);
            logUrl(model.logUrl);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getServerName() {
            return serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getLogUrl() {
            return logUrl;
        }

        @Override
        public final Builder logUrl(String logUrl) {
            this.logUrl = logUrl;
            return this;
        }

        public final void setLogUrl(String logUrl) {
            this.logUrl = logUrl;
        }

        @Override
        public ServerEvent build() {
            return new ServerEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
