/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeNodeAssociationStatusResponse extends OpsWorksCmResponse implements
        ToCopyableBuilder<DescribeNodeAssociationStatusResponse.Builder, DescribeNodeAssociationStatusResponse> {
    private static final SdkField<String> NODE_ASSOCIATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeNodeAssociationStatusResponse::nodeAssociationStatusAsString))
            .setter(setter(Builder::nodeAssociationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeAssociationStatus").build())
            .build();

    private static final SdkField<List<EngineAttribute>> ENGINE_ATTRIBUTES_FIELD = SdkField
            .<List<EngineAttribute>> builder(MarshallingType.LIST)
            .getter(getter(DescribeNodeAssociationStatusResponse::engineAttributes))
            .setter(setter(Builder::engineAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EngineAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(EngineAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_ASSOCIATION_STATUS_FIELD,
            ENGINE_ATTRIBUTES_FIELD));

    private final String nodeAssociationStatus;

    private final List<EngineAttribute> engineAttributes;

    private DescribeNodeAssociationStatusResponse(BuilderImpl builder) {
        super(builder);
        this.nodeAssociationStatus = builder.nodeAssociationStatus;
        this.engineAttributes = builder.engineAttributes;
    }

    /**
     * <p>
     * The status of the association or disassociation request.
     * </p>
     * <p class="title">
     * <b>Possible values:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUCCESS</code>: The association or disassociation succeeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>: The association or disassociation failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code>: The association or disassociation is still in progress.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nodeAssociationStatus} will return {@link NodeAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #nodeAssociationStatusAsString}.
     * </p>
     * 
     * @return The status of the association or disassociation request. </p>
     *         <p class="title">
     *         <b>Possible values:</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SUCCESS</code>: The association or disassociation succeeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>: The association or disassociation failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code>: The association or disassociation is still in progress.
     *         </p>
     *         </li>
     * @see NodeAssociationStatus
     */
    public NodeAssociationStatus nodeAssociationStatus() {
        return NodeAssociationStatus.fromValue(nodeAssociationStatus);
    }

    /**
     * <p>
     * The status of the association or disassociation request.
     * </p>
     * <p class="title">
     * <b>Possible values:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUCCESS</code>: The association or disassociation succeeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>: The association or disassociation failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code>: The association or disassociation is still in progress.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nodeAssociationStatus} will return {@link NodeAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #nodeAssociationStatusAsString}.
     * </p>
     * 
     * @return The status of the association or disassociation request. </p>
     *         <p class="title">
     *         <b>Possible values:</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SUCCESS</code>: The association or disassociation succeeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>: The association or disassociation failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code>: The association or disassociation is still in progress.
     *         </p>
     *         </li>
     * @see NodeAssociationStatus
     */
    public String nodeAssociationStatusAsString() {
        return nodeAssociationStatus;
    }

    /**
     * Returns true if the EngineAttributes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasEngineAttributes() {
        return engineAttributes != null && !(engineAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Attributes specific to the node association. In Puppet, the attibute PUPPET_NODE_CERT contains the signed
     * certificate (the result of the CSR).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEngineAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Attributes specific to the node association. In Puppet, the attibute PUPPET_NODE_CERT contains the signed
     *         certificate (the result of the CSR).
     */
    public List<EngineAttribute> engineAttributes() {
        return engineAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nodeAssociationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(engineAttributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNodeAssociationStatusResponse)) {
            return false;
        }
        DescribeNodeAssociationStatusResponse other = (DescribeNodeAssociationStatusResponse) obj;
        return Objects.equals(nodeAssociationStatusAsString(), other.nodeAssociationStatusAsString())
                && Objects.equals(engineAttributes(), other.engineAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeNodeAssociationStatusResponse")
                .add("NodeAssociationStatus", nodeAssociationStatusAsString()).add("EngineAttributes", engineAttributes())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NodeAssociationStatus":
            return Optional.ofNullable(clazz.cast(nodeAssociationStatusAsString()));
        case "EngineAttributes":
            return Optional.ofNullable(clazz.cast(engineAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNodeAssociationStatusResponse, T> g) {
        return obj -> g.apply((DescribeNodeAssociationStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksCmResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeNodeAssociationStatusResponse> {
        /**
         * <p>
         * The status of the association or disassociation request.
         * </p>
         * <p class="title">
         * <b>Possible values:</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SUCCESS</code>: The association or disassociation succeeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>: The association or disassociation failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code>: The association or disassociation is still in progress.
         * </p>
         * </li>
         * </ul>
         * 
         * @param nodeAssociationStatus
         *        The status of the association or disassociation request. </p>
         *        <p class="title">
         *        <b>Possible values:</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SUCCESS</code>: The association or disassociation succeeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>: The association or disassociation failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code>: The association or disassociation is still in progress.
         *        </p>
         *        </li>
         * @see NodeAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeAssociationStatus
         */
        Builder nodeAssociationStatus(String nodeAssociationStatus);

        /**
         * <p>
         * The status of the association or disassociation request.
         * </p>
         * <p class="title">
         * <b>Possible values:</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SUCCESS</code>: The association or disassociation succeeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>: The association or disassociation failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code>: The association or disassociation is still in progress.
         * </p>
         * </li>
         * </ul>
         * 
         * @param nodeAssociationStatus
         *        The status of the association or disassociation request. </p>
         *        <p class="title">
         *        <b>Possible values:</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SUCCESS</code>: The association or disassociation succeeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>: The association or disassociation failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code>: The association or disassociation is still in progress.
         *        </p>
         *        </li>
         * @see NodeAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeAssociationStatus
         */
        Builder nodeAssociationStatus(NodeAssociationStatus nodeAssociationStatus);

        /**
         * <p>
         * Attributes specific to the node association. In Puppet, the attibute PUPPET_NODE_CERT contains the signed
         * certificate (the result of the CSR).
         * </p>
         * 
         * @param engineAttributes
         *        Attributes specific to the node association. In Puppet, the attibute PUPPET_NODE_CERT contains the
         *        signed certificate (the result of the CSR).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineAttributes(Collection<EngineAttribute> engineAttributes);

        /**
         * <p>
         * Attributes specific to the node association. In Puppet, the attibute PUPPET_NODE_CERT contains the signed
         * certificate (the result of the CSR).
         * </p>
         * 
         * @param engineAttributes
         *        Attributes specific to the node association. In Puppet, the attibute PUPPET_NODE_CERT contains the
         *        signed certificate (the result of the CSR).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineAttributes(EngineAttribute... engineAttributes);

        /**
         * <p>
         * Attributes specific to the node association. In Puppet, the attibute PUPPET_NODE_CERT contains the signed
         * certificate (the result of the CSR).
         * </p>
         * This is a convenience that creates an instance of the {@link List<EngineAttribute>.Builder} avoiding the need
         * to create one manually via {@link List<EngineAttribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EngineAttribute>.Builder#build()} is called immediately and
         * its result is passed to {@link #engineAttributes(List<EngineAttribute>)}.
         * 
         * @param engineAttributes
         *        a consumer that will call methods on {@link List<EngineAttribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #engineAttributes(List<EngineAttribute>)
         */
        Builder engineAttributes(Consumer<EngineAttribute.Builder>... engineAttributes);
    }

    static final class BuilderImpl extends OpsWorksCmResponse.BuilderImpl implements Builder {
        private String nodeAssociationStatus;

        private List<EngineAttribute> engineAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNodeAssociationStatusResponse model) {
            super(model);
            nodeAssociationStatus(model.nodeAssociationStatus);
            engineAttributes(model.engineAttributes);
        }

        public final String getNodeAssociationStatusAsString() {
            return nodeAssociationStatus;
        }

        @Override
        public final Builder nodeAssociationStatus(String nodeAssociationStatus) {
            this.nodeAssociationStatus = nodeAssociationStatus;
            return this;
        }

        @Override
        public final Builder nodeAssociationStatus(NodeAssociationStatus nodeAssociationStatus) {
            this.nodeAssociationStatus(nodeAssociationStatus == null ? null : nodeAssociationStatus.toString());
            return this;
        }

        public final void setNodeAssociationStatus(String nodeAssociationStatus) {
            this.nodeAssociationStatus = nodeAssociationStatus;
        }

        public final Collection<EngineAttribute.Builder> getEngineAttributes() {
            return engineAttributes != null ? engineAttributes.stream().map(EngineAttribute::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder engineAttributes(Collection<EngineAttribute> engineAttributes) {
            this.engineAttributes = EngineAttributesCopier.copy(engineAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineAttributes(EngineAttribute... engineAttributes) {
            engineAttributes(Arrays.asList(engineAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineAttributes(Consumer<EngineAttribute.Builder>... engineAttributes) {
            engineAttributes(Stream.of(engineAttributes).map(c -> EngineAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEngineAttributes(Collection<EngineAttribute.BuilderImpl> engineAttributes) {
            this.engineAttributes = EngineAttributesCopier.copyFromBuilder(engineAttributes);
        }

        @Override
        public DescribeNodeAssociationStatusResponse build() {
            return new DescribeNodeAssociationStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
