/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBackupRequest extends OpsWorksCmRequest implements
        ToCopyableBuilder<CreateBackupRequest.Builder, CreateBackupRequest> {
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateBackupRequest::serverName)).setter(setter(Builder::serverName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateBackupRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateBackupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_NAME_FIELD,
            DESCRIPTION_FIELD, TAGS_FIELD));

    private final String serverName;

    private final String description;

    private final List<Tag> tags;

    private CreateBackupRequest(BuilderImpl builder) {
        super(builder);
        this.serverName = builder.serverName;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the server that you want to back up.
     * </p>
     * 
     * @return The name of the server that you want to back up.
     */
    public String serverName() {
        return serverName;
    }

    /**
     * <p>
     * A user-defined description of the backup.
     * </p>
     * 
     * @return A user-defined description of the backup.
     */
    public String description() {
        return description;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A map that contains tag keys and tag values to attach to an AWS OpsWorks-CM server backup.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The key cannot be empty.
     * </p>
     * </li>
     * <li>
     * <p>
     * The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or separators, or the
     * following special characters: <code>+ - = . _ : /</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * The value can be a maximum 255 characters, and contain only Unicode letters, numbers, or separators, or the
     * following special characters: <code>+ - = . _ : /</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Leading and trailing white spaces are trimmed from both the key and value.
     * </p>
     * </li>
     * <li>
     * <p>
     * A maximum of 50 user-applied tags is allowed for tag-supported AWS OpsWorks-CM resources.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map that contains tag keys and tag values to attach to an AWS OpsWorks-CM server backup.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The key cannot be empty.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or separators,
     *         or the following special characters: <code>+ - = . _ : /</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The value can be a maximum 255 characters, and contain only Unicode letters, numbers, or separators, or
     *         the following special characters: <code>+ - = . _ : /</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Leading and trailing white spaces are trimmed from both the key and value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A maximum of 50 user-applied tags is allowed for tag-supported AWS OpsWorks-CM resources.
     *         </p>
     *         </li>
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serverName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBackupRequest)) {
            return false;
        }
        CreateBackupRequest other = (CreateBackupRequest) obj;
        return Objects.equals(serverName(), other.serverName()) && Objects.equals(description(), other.description())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateBackupRequest").add("ServerName", serverName()).add("Description", description())
                .add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerName":
            return Optional.ofNullable(clazz.cast(serverName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBackupRequest, T> g) {
        return obj -> g.apply((CreateBackupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksCmRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateBackupRequest> {
        /**
         * <p>
         * The name of the server that you want to back up.
         * </p>
         * 
         * @param serverName
         *        The name of the server that you want to back up.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverName(String serverName);

        /**
         * <p>
         * A user-defined description of the backup.
         * </p>
         * 
         * @param description
         *        A user-defined description of the backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A map that contains tag keys and tag values to attach to an AWS OpsWorks-CM server backup.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The key cannot be empty.
         * </p>
         * </li>
         * <li>
         * <p>
         * The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or separators, or
         * the following special characters: <code>+ - = . _ : /</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * The value can be a maximum 255 characters, and contain only Unicode letters, numbers, or separators, or the
         * following special characters: <code>+ - = . _ : /</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Leading and trailing white spaces are trimmed from both the key and value.
         * </p>
         * </li>
         * <li>
         * <p>
         * A maximum of 50 user-applied tags is allowed for tag-supported AWS OpsWorks-CM resources.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        A map that contains tag keys and tag values to attach to an AWS OpsWorks-CM server backup.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The key cannot be empty.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or
         *        separators, or the following special characters: <code>+ - = . _ : /</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The value can be a maximum 255 characters, and contain only Unicode letters, numbers, or separators,
         *        or the following special characters: <code>+ - = . _ : /</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Leading and trailing white spaces are trimmed from both the key and value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A maximum of 50 user-applied tags is allowed for tag-supported AWS OpsWorks-CM resources.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A map that contains tag keys and tag values to attach to an AWS OpsWorks-CM server backup.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The key cannot be empty.
         * </p>
         * </li>
         * <li>
         * <p>
         * The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or separators, or
         * the following special characters: <code>+ - = . _ : /</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * The value can be a maximum 255 characters, and contain only Unicode letters, numbers, or separators, or the
         * following special characters: <code>+ - = . _ : /</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Leading and trailing white spaces are trimmed from both the key and value.
         * </p>
         * </li>
         * <li>
         * <p>
         * A maximum of 50 user-applied tags is allowed for tag-supported AWS OpsWorks-CM resources.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        A map that contains tag keys and tag values to attach to an AWS OpsWorks-CM server backup.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The key cannot be empty.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or
         *        separators, or the following special characters: <code>+ - = . _ : /</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The value can be a maximum 255 characters, and contain only Unicode letters, numbers, or separators,
         *        or the following special characters: <code>+ - = . _ : /</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Leading and trailing white spaces are trimmed from both the key and value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A maximum of 50 user-applied tags is allowed for tag-supported AWS OpsWorks-CM resources.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A map that contains tag keys and tag values to attach to an AWS OpsWorks-CM server backup.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The key cannot be empty.
         * </p>
         * </li>
         * <li>
         * <p>
         * The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or separators, or
         * the following special characters: <code>+ - = . _ : /</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * The value can be a maximum 255 characters, and contain only Unicode letters, numbers, or separators, or the
         * following special characters: <code>+ - = . _ : /</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Leading and trailing white spaces are trimmed from both the key and value.
         * </p>
         * </li>
         * <li>
         * <p>
         * A maximum of 50 user-applied tags is allowed for tag-supported AWS OpsWorks-CM resources.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksCmRequest.BuilderImpl implements Builder {
        private String serverName;

        private String description;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBackupRequest model) {
            super(model);
            serverName(model.serverName);
            description(model.description);
            tags(model.tags);
        }

        public final String getServerName() {
            return serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBackupRequest build() {
            return new CreateBackupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
