/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworkscm.model.AssociateNodeRequest;

@SdkInternalApi
public class AssociateNodeRequestModelMarshaller {
    private static final MarshallingInfo<String> SERVERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServerName").build();
    private static final MarshallingInfo<String> NODENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NodeName").build();
    private static final MarshallingInfo<List> ENGINEATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EngineAttributes").build();
    private static final AssociateNodeRequestModelMarshaller INSTANCE = new AssociateNodeRequestModelMarshaller();

    public static AssociateNodeRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AssociateNodeRequest associateNodeRequest, ProtocolMarshaller protocolMarshaller) {
        if (associateNodeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)associateNodeRequest.serverName(), SERVERNAME_BINDING);
            protocolMarshaller.marshall((Object)associateNodeRequest.nodeName(), NODENAME_BINDING);
            protocolMarshaller.marshall(associateNodeRequest.engineAttributes(), ENGINEATTRIBUTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

