/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.opsworkscm.model.OpsWorksCMResponse;
import software.amazon.awssdk.services.opsworkscm.model.Server;
import software.amazon.awssdk.services.opsworkscm.model.ServersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeServersResponse
extends OpsWorksCMResponse
implements ToCopyableBuilder<Builder, DescribeServersResponse> {
    private final List<Server> servers;
    private final String nextToken;

    private DescribeServersResponse(BuilderImpl builder) {
        super(builder);
        this.servers = builder.servers;
        this.nextToken = builder.nextToken;
    }

    public List<Server> servers() {
        return this.servers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.servers());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServersResponse)) {
            return false;
        }
        DescribeServersResponse other = (DescribeServersResponse)((Object)obj);
        return Objects.equals(this.servers(), other.servers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeServersResponse").add("Servers", this.servers()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Servers": {
                return Optional.of(clazz.cast(this.servers()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksCMResponse.BuilderImpl
    implements Builder {
        private List<Server> servers;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServersResponse model) {
            this.servers(model.servers);
            this.nextToken(model.nextToken);
        }

        public final Collection<Server.Builder> getServers() {
            return this.servers != null ? (Collection)this.servers.stream().map(Server::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder servers(Collection<Server> servers) {
            this.servers = ServersCopier.copy(servers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder servers(Server ... servers) {
            this.servers(Arrays.asList(servers));
            return this;
        }

        public final void setServers(Collection<Server.BuilderImpl> servers) {
            this.servers = ServersCopier.copyFromBuilder(servers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeServersResponse build() {
            return new DescribeServersResponse(this);
        }
    }

    public static interface Builder
    extends OpsWorksCMResponse.Builder,
    CopyableBuilder<Builder, DescribeServersResponse> {
        public Builder servers(Collection<Server> var1);

        public Builder servers(Server ... var1);

        public Builder nextToken(String var1);
    }
}

