/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.opsworkscm.model.OpsWorksCMResponse;
import software.amazon.awssdk.services.opsworkscm.model.ServerEvent;
import software.amazon.awssdk.services.opsworkscm.model.ServerEventsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEventsResponse
extends OpsWorksCMResponse
implements ToCopyableBuilder<Builder, DescribeEventsResponse> {
    private final List<ServerEvent> serverEvents;
    private final String nextToken;

    private DescribeEventsResponse(BuilderImpl builder) {
        super(builder);
        this.serverEvents = builder.serverEvents;
        this.nextToken = builder.nextToken;
    }

    public List<ServerEvent> serverEvents() {
        return this.serverEvents;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serverEvents());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventsResponse)) {
            return false;
        }
        DescribeEventsResponse other = (DescribeEventsResponse)((Object)obj);
        return Objects.equals(this.serverEvents(), other.serverEvents()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.serverEvents() != null) {
            sb.append("ServerEvents: ").append(this.serverEvents()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServerEvents": {
                return Optional.of(clazz.cast(this.serverEvents()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksCMResponse.BuilderImpl
    implements Builder {
        private List<ServerEvent> serverEvents;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventsResponse model) {
            this.serverEvents(model.serverEvents);
            this.nextToken(model.nextToken);
        }

        public final Collection<ServerEvent.Builder> getServerEvents() {
            return this.serverEvents != null ? (Collection)this.serverEvents.stream().map(ServerEvent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serverEvents(Collection<ServerEvent> serverEvents) {
            this.serverEvents = ServerEventsCopier.copy(serverEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverEvents(ServerEvent ... serverEvents) {
            this.serverEvents(Arrays.asList(serverEvents));
            return this;
        }

        public final void setServerEvents(Collection<ServerEvent.BuilderImpl> serverEvents) {
            this.serverEvents = ServerEventsCopier.copyFromBuilder(serverEvents);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeEventsResponse build() {
            return new DescribeEventsResponse(this);
        }
    }

    public static interface Builder
    extends OpsWorksCMResponse.Builder,
    CopyableBuilder<Builder, DescribeEventsResponse> {
        public Builder serverEvents(Collection<ServerEvent> var1);

        public Builder serverEvents(ServerEvent ... var1);

        public Builder nextToken(String var1);
    }
}

