/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworkscm.model.EngineAttribute;
import software.amazon.awssdk.services.opsworkscm.model.EngineAttributesCopier;
import software.amazon.awssdk.services.opsworkscm.model.MaintenanceStatus;
import software.amazon.awssdk.services.opsworkscm.model.ServerStatus;
import software.amazon.awssdk.services.opsworkscm.model.StringsCopier;
import software.amazon.awssdk.services.opsworkscm.transform.ServerMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Server
implements StructuredPojo,
ToCopyableBuilder<Builder, Server> {
    private final Boolean associatePublicIpAddress;
    private final Integer backupRetentionCount;
    private final String serverName;
    private final Instant createdAt;
    private final String cloudFormationStackArn;
    private final Boolean disableAutomatedBackup;
    private final String endpoint;
    private final String engine;
    private final String engineModel;
    private final List<EngineAttribute> engineAttributes;
    private final String engineVersion;
    private final String instanceProfileArn;
    private final String instanceType;
    private final String keyPair;
    private final String maintenanceStatus;
    private final String preferredMaintenanceWindow;
    private final String preferredBackupWindow;
    private final List<String> securityGroupIds;
    private final String serviceRoleArn;
    private final String status;
    private final String statusReason;
    private final List<String> subnetIds;
    private final String serverArn;

    private Server(BuilderImpl builder) {
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.backupRetentionCount = builder.backupRetentionCount;
        this.serverName = builder.serverName;
        this.createdAt = builder.createdAt;
        this.cloudFormationStackArn = builder.cloudFormationStackArn;
        this.disableAutomatedBackup = builder.disableAutomatedBackup;
        this.endpoint = builder.endpoint;
        this.engine = builder.engine;
        this.engineModel = builder.engineModel;
        this.engineAttributes = builder.engineAttributes;
        this.engineVersion = builder.engineVersion;
        this.instanceProfileArn = builder.instanceProfileArn;
        this.instanceType = builder.instanceType;
        this.keyPair = builder.keyPair;
        this.maintenanceStatus = builder.maintenanceStatus;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.securityGroupIds = builder.securityGroupIds;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.subnetIds = builder.subnetIds;
        this.serverArn = builder.serverArn;
    }

    public Boolean associatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }

    public Integer backupRetentionCount() {
        return this.backupRetentionCount;
    }

    public String serverName() {
        return this.serverName;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public String cloudFormationStackArn() {
        return this.cloudFormationStackArn;
    }

    public Boolean disableAutomatedBackup() {
        return this.disableAutomatedBackup;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public String engine() {
        return this.engine;
    }

    public String engineModel() {
        return this.engineModel;
    }

    public List<EngineAttribute> engineAttributes() {
        return this.engineAttributes;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String instanceProfileArn() {
        return this.instanceProfileArn;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public String keyPair() {
        return this.keyPair;
    }

    public MaintenanceStatus maintenanceStatus() {
        return MaintenanceStatus.fromValue(this.maintenanceStatus);
    }

    public String maintenanceStatusString() {
        return this.maintenanceStatus;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public String preferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public String serviceRoleArn() {
        return this.serviceRoleArn;
    }

    public ServerStatus status() {
        return ServerStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String statusReason() {
        return this.statusReason;
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public String serverArn() {
        return this.serverArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.associatePublicIpAddress() == null ? 0 : this.associatePublicIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.backupRetentionCount() == null ? 0 : this.backupRetentionCount().hashCode());
        hashCode = 31 * hashCode + (this.serverName() == null ? 0 : this.serverName().hashCode());
        hashCode = 31 * hashCode + (this.createdAt() == null ? 0 : this.createdAt().hashCode());
        hashCode = 31 * hashCode + (this.cloudFormationStackArn() == null ? 0 : this.cloudFormationStackArn().hashCode());
        hashCode = 31 * hashCode + (this.disableAutomatedBackup() == null ? 0 : this.disableAutomatedBackup().hashCode());
        hashCode = 31 * hashCode + (this.endpoint() == null ? 0 : this.endpoint().hashCode());
        hashCode = 31 * hashCode + (this.engine() == null ? 0 : this.engine().hashCode());
        hashCode = 31 * hashCode + (this.engineModel() == null ? 0 : this.engineModel().hashCode());
        hashCode = 31 * hashCode + (this.engineAttributes() == null ? 0 : this.engineAttributes().hashCode());
        hashCode = 31 * hashCode + (this.engineVersion() == null ? 0 : this.engineVersion().hashCode());
        hashCode = 31 * hashCode + (this.instanceProfileArn() == null ? 0 : this.instanceProfileArn().hashCode());
        hashCode = 31 * hashCode + (this.instanceType() == null ? 0 : this.instanceType().hashCode());
        hashCode = 31 * hashCode + (this.keyPair() == null ? 0 : this.keyPair().hashCode());
        hashCode = 31 * hashCode + (this.maintenanceStatusString() == null ? 0 : this.maintenanceStatusString().hashCode());
        hashCode = 31 * hashCode + (this.preferredMaintenanceWindow() == null ? 0 : this.preferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.preferredBackupWindow() == null ? 0 : this.preferredBackupWindow().hashCode());
        hashCode = 31 * hashCode + (this.securityGroupIds() == null ? 0 : this.securityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.serviceRoleArn() == null ? 0 : this.serviceRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.statusString() == null ? 0 : this.statusString().hashCode());
        hashCode = 31 * hashCode + (this.statusReason() == null ? 0 : this.statusReason().hashCode());
        hashCode = 31 * hashCode + (this.subnetIds() == null ? 0 : this.subnetIds().hashCode());
        hashCode = 31 * hashCode + (this.serverArn() == null ? 0 : this.serverArn().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Server)) {
            return false;
        }
        Server other = (Server)obj;
        if (other.associatePublicIpAddress() == null ^ this.associatePublicIpAddress() == null) {
            return false;
        }
        if (other.associatePublicIpAddress() != null && !other.associatePublicIpAddress().equals(this.associatePublicIpAddress())) {
            return false;
        }
        if (other.backupRetentionCount() == null ^ this.backupRetentionCount() == null) {
            return false;
        }
        if (other.backupRetentionCount() != null && !other.backupRetentionCount().equals(this.backupRetentionCount())) {
            return false;
        }
        if (other.serverName() == null ^ this.serverName() == null) {
            return false;
        }
        if (other.serverName() != null && !other.serverName().equals(this.serverName())) {
            return false;
        }
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        if (other.createdAt() != null && !other.createdAt().equals(this.createdAt())) {
            return false;
        }
        if (other.cloudFormationStackArn() == null ^ this.cloudFormationStackArn() == null) {
            return false;
        }
        if (other.cloudFormationStackArn() != null && !other.cloudFormationStackArn().equals(this.cloudFormationStackArn())) {
            return false;
        }
        if (other.disableAutomatedBackup() == null ^ this.disableAutomatedBackup() == null) {
            return false;
        }
        if (other.disableAutomatedBackup() != null && !other.disableAutomatedBackup().equals(this.disableAutomatedBackup())) {
            return false;
        }
        if (other.endpoint() == null ^ this.endpoint() == null) {
            return false;
        }
        if (other.endpoint() != null && !other.endpoint().equals(this.endpoint())) {
            return false;
        }
        if (other.engine() == null ^ this.engine() == null) {
            return false;
        }
        if (other.engine() != null && !other.engine().equals(this.engine())) {
            return false;
        }
        if (other.engineModel() == null ^ this.engineModel() == null) {
            return false;
        }
        if (other.engineModel() != null && !other.engineModel().equals(this.engineModel())) {
            return false;
        }
        if (other.engineAttributes() == null ^ this.engineAttributes() == null) {
            return false;
        }
        if (other.engineAttributes() != null && !other.engineAttributes().equals(this.engineAttributes())) {
            return false;
        }
        if (other.engineVersion() == null ^ this.engineVersion() == null) {
            return false;
        }
        if (other.engineVersion() != null && !other.engineVersion().equals(this.engineVersion())) {
            return false;
        }
        if (other.instanceProfileArn() == null ^ this.instanceProfileArn() == null) {
            return false;
        }
        if (other.instanceProfileArn() != null && !other.instanceProfileArn().equals(this.instanceProfileArn())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.keyPair() == null ^ this.keyPair() == null) {
            return false;
        }
        if (other.keyPair() != null && !other.keyPair().equals(this.keyPair())) {
            return false;
        }
        if (other.maintenanceStatusString() == null ^ this.maintenanceStatusString() == null) {
            return false;
        }
        if (other.maintenanceStatusString() != null && !other.maintenanceStatusString().equals(this.maintenanceStatusString())) {
            return false;
        }
        if (other.preferredMaintenanceWindow() == null ^ this.preferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.preferredMaintenanceWindow() != null && !other.preferredMaintenanceWindow().equals(this.preferredMaintenanceWindow())) {
            return false;
        }
        if (other.preferredBackupWindow() == null ^ this.preferredBackupWindow() == null) {
            return false;
        }
        if (other.preferredBackupWindow() != null && !other.preferredBackupWindow().equals(this.preferredBackupWindow())) {
            return false;
        }
        if (other.securityGroupIds() == null ^ this.securityGroupIds() == null) {
            return false;
        }
        if (other.securityGroupIds() != null && !other.securityGroupIds().equals(this.securityGroupIds())) {
            return false;
        }
        if (other.serviceRoleArn() == null ^ this.serviceRoleArn() == null) {
            return false;
        }
        if (other.serviceRoleArn() != null && !other.serviceRoleArn().equals(this.serviceRoleArn())) {
            return false;
        }
        if (other.statusString() == null ^ this.statusString() == null) {
            return false;
        }
        if (other.statusString() != null && !other.statusString().equals(this.statusString())) {
            return false;
        }
        if (other.statusReason() == null ^ this.statusReason() == null) {
            return false;
        }
        if (other.statusReason() != null && !other.statusReason().equals(this.statusReason())) {
            return false;
        }
        if (other.subnetIds() == null ^ this.subnetIds() == null) {
            return false;
        }
        if (other.subnetIds() != null && !other.subnetIds().equals(this.subnetIds())) {
            return false;
        }
        if (other.serverArn() == null ^ this.serverArn() == null) {
            return false;
        }
        return other.serverArn() == null || other.serverArn().equals(this.serverArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.associatePublicIpAddress() != null) {
            sb.append("AssociatePublicIpAddress: ").append(this.associatePublicIpAddress()).append(",");
        }
        if (this.backupRetentionCount() != null) {
            sb.append("BackupRetentionCount: ").append(this.backupRetentionCount()).append(",");
        }
        if (this.serverName() != null) {
            sb.append("ServerName: ").append(this.serverName()).append(",");
        }
        if (this.createdAt() != null) {
            sb.append("CreatedAt: ").append(this.createdAt()).append(",");
        }
        if (this.cloudFormationStackArn() != null) {
            sb.append("CloudFormationStackArn: ").append(this.cloudFormationStackArn()).append(",");
        }
        if (this.disableAutomatedBackup() != null) {
            sb.append("DisableAutomatedBackup: ").append(this.disableAutomatedBackup()).append(",");
        }
        if (this.endpoint() != null) {
            sb.append("Endpoint: ").append(this.endpoint()).append(",");
        }
        if (this.engine() != null) {
            sb.append("Engine: ").append(this.engine()).append(",");
        }
        if (this.engineModel() != null) {
            sb.append("EngineModel: ").append(this.engineModel()).append(",");
        }
        if (this.engineAttributes() != null) {
            sb.append("EngineAttributes: ").append(this.engineAttributes()).append(",");
        }
        if (this.engineVersion() != null) {
            sb.append("EngineVersion: ").append(this.engineVersion()).append(",");
        }
        if (this.instanceProfileArn() != null) {
            sb.append("InstanceProfileArn: ").append(this.instanceProfileArn()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.keyPair() != null) {
            sb.append("KeyPair: ").append(this.keyPair()).append(",");
        }
        if (this.maintenanceStatusString() != null) {
            sb.append("MaintenanceStatus: ").append(this.maintenanceStatusString()).append(",");
        }
        if (this.preferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: ").append(this.preferredMaintenanceWindow()).append(",");
        }
        if (this.preferredBackupWindow() != null) {
            sb.append("PreferredBackupWindow: ").append(this.preferredBackupWindow()).append(",");
        }
        if (this.securityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(this.securityGroupIds()).append(",");
        }
        if (this.serviceRoleArn() != null) {
            sb.append("ServiceRoleArn: ").append(this.serviceRoleArn()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.statusReason() != null) {
            sb.append("StatusReason: ").append(this.statusReason()).append(",");
        }
        if (this.subnetIds() != null) {
            sb.append("SubnetIds: ").append(this.subnetIds()).append(",");
        }
        if (this.serverArn() != null) {
            sb.append("ServerArn: ").append(this.serverArn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociatePublicIpAddress": {
                return Optional.of(clazz.cast(this.associatePublicIpAddress()));
            }
            case "BackupRetentionCount": {
                return Optional.of(clazz.cast(this.backupRetentionCount()));
            }
            case "ServerName": {
                return Optional.of(clazz.cast(this.serverName()));
            }
            case "CreatedAt": {
                return Optional.of(clazz.cast(this.createdAt()));
            }
            case "CloudFormationStackArn": {
                return Optional.of(clazz.cast(this.cloudFormationStackArn()));
            }
            case "DisableAutomatedBackup": {
                return Optional.of(clazz.cast(this.disableAutomatedBackup()));
            }
            case "Endpoint": {
                return Optional.of(clazz.cast(this.endpoint()));
            }
            case "Engine": {
                return Optional.of(clazz.cast(this.engine()));
            }
            case "EngineModel": {
                return Optional.of(clazz.cast(this.engineModel()));
            }
            case "EngineAttributes": {
                return Optional.of(clazz.cast(this.engineAttributes()));
            }
            case "EngineVersion": {
                return Optional.of(clazz.cast(this.engineVersion()));
            }
            case "InstanceProfileArn": {
                return Optional.of(clazz.cast(this.instanceProfileArn()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceType()));
            }
            case "KeyPair": {
                return Optional.of(clazz.cast(this.keyPair()));
            }
            case "MaintenanceStatus": {
                return Optional.of(clazz.cast(this.maintenanceStatusString()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.of(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "PreferredBackupWindow": {
                return Optional.of(clazz.cast(this.preferredBackupWindow()));
            }
            case "SecurityGroupIds": {
                return Optional.of(clazz.cast(this.securityGroupIds()));
            }
            case "ServiceRoleArn": {
                return Optional.of(clazz.cast(this.serviceRoleArn()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "StatusReason": {
                return Optional.of(clazz.cast(this.statusReason()));
            }
            case "SubnetIds": {
                return Optional.of(clazz.cast(this.subnetIds()));
            }
            case "ServerArn": {
                return Optional.of(clazz.cast(this.serverArn()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ServerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean associatePublicIpAddress;
        private Integer backupRetentionCount;
        private String serverName;
        private Instant createdAt;
        private String cloudFormationStackArn;
        private Boolean disableAutomatedBackup;
        private String endpoint;
        private String engine;
        private String engineModel;
        private List<EngineAttribute> engineAttributes;
        private String engineVersion;
        private String instanceProfileArn;
        private String instanceType;
        private String keyPair;
        private String maintenanceStatus;
        private String preferredMaintenanceWindow;
        private String preferredBackupWindow;
        private List<String> securityGroupIds;
        private String serviceRoleArn;
        private String status;
        private String statusReason;
        private List<String> subnetIds;
        private String serverArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Server model) {
            this.associatePublicIpAddress(model.associatePublicIpAddress);
            this.backupRetentionCount(model.backupRetentionCount);
            this.serverName(model.serverName);
            this.createdAt(model.createdAt);
            this.cloudFormationStackArn(model.cloudFormationStackArn);
            this.disableAutomatedBackup(model.disableAutomatedBackup);
            this.endpoint(model.endpoint);
            this.engine(model.engine);
            this.engineModel(model.engineModel);
            this.engineAttributes(model.engineAttributes);
            this.engineVersion(model.engineVersion);
            this.instanceProfileArn(model.instanceProfileArn);
            this.instanceType(model.instanceType);
            this.keyPair(model.keyPair);
            this.maintenanceStatus(model.maintenanceStatus);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.preferredBackupWindow(model.preferredBackupWindow);
            this.securityGroupIds(model.securityGroupIds);
            this.serviceRoleArn(model.serviceRoleArn);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.subnetIds(model.subnetIds);
            this.serverArn(model.serverArn);
        }

        public final Boolean getAssociatePublicIpAddress() {
            return this.associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        public final Integer getBackupRetentionCount() {
            return this.backupRetentionCount;
        }

        @Override
        public final Builder backupRetentionCount(Integer backupRetentionCount) {
            this.backupRetentionCount = backupRetentionCount;
            return this;
        }

        public final void setBackupRetentionCount(Integer backupRetentionCount) {
            this.backupRetentionCount = backupRetentionCount;
        }

        public final String getServerName() {
            return this.serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getCloudFormationStackArn() {
            return this.cloudFormationStackArn;
        }

        @Override
        public final Builder cloudFormationStackArn(String cloudFormationStackArn) {
            this.cloudFormationStackArn = cloudFormationStackArn;
            return this;
        }

        public final void setCloudFormationStackArn(String cloudFormationStackArn) {
            this.cloudFormationStackArn = cloudFormationStackArn;
        }

        public final Boolean getDisableAutomatedBackup() {
            return this.disableAutomatedBackup;
        }

        @Override
        public final Builder disableAutomatedBackup(Boolean disableAutomatedBackup) {
            this.disableAutomatedBackup = disableAutomatedBackup;
            return this;
        }

        public final void setDisableAutomatedBackup(Boolean disableAutomatedBackup) {
            this.disableAutomatedBackup = disableAutomatedBackup;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineModel() {
            return this.engineModel;
        }

        @Override
        public final Builder engineModel(String engineModel) {
            this.engineModel = engineModel;
            return this;
        }

        public final void setEngineModel(String engineModel) {
            this.engineModel = engineModel;
        }

        public final Collection<EngineAttribute.Builder> getEngineAttributes() {
            return this.engineAttributes != null ? (Collection)this.engineAttributes.stream().map(EngineAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder engineAttributes(Collection<EngineAttribute> engineAttributes) {
            this.engineAttributes = EngineAttributesCopier.copy(engineAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineAttributes(EngineAttribute ... engineAttributes) {
            this.engineAttributes(Arrays.asList(engineAttributes));
            return this;
        }

        public final void setEngineAttributes(Collection<EngineAttribute.BuilderImpl> engineAttributes) {
            this.engineAttributes = EngineAttributesCopier.copyFromBuilder(engineAttributes);
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getInstanceProfileArn() {
            return this.instanceProfileArn;
        }

        @Override
        public final Builder instanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
            return this;
        }

        public final void setInstanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKeyPair() {
            return this.keyPair;
        }

        @Override
        public final Builder keyPair(String keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public final void setKeyPair(String keyPair) {
            this.keyPair = keyPair;
        }

        public final String getMaintenanceStatus() {
            return this.maintenanceStatus;
        }

        @Override
        public final Builder maintenanceStatus(String maintenanceStatus) {
            this.maintenanceStatus = maintenanceStatus;
            return this;
        }

        @Override
        public final Builder maintenanceStatus(MaintenanceStatus maintenanceStatus) {
            this.maintenanceStatus(maintenanceStatus.toString());
            return this;
        }

        public final void setMaintenanceStatus(String maintenanceStatus) {
            this.maintenanceStatus = maintenanceStatus;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringsCopier.copy(securityGroupIds);
        }

        public final String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ServerStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final Collection<String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringsCopier.copy(subnetIds);
        }

        public final String getServerArn() {
            return this.serverArn;
        }

        @Override
        public final Builder serverArn(String serverArn) {
            this.serverArn = serverArn;
            return this;
        }

        public final void setServerArn(String serverArn) {
            this.serverArn = serverArn;
        }

        public Server build() {
            return new Server(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Server> {
        public Builder associatePublicIpAddress(Boolean var1);

        public Builder backupRetentionCount(Integer var1);

        public Builder serverName(String var1);

        public Builder createdAt(Instant var1);

        public Builder cloudFormationStackArn(String var1);

        public Builder disableAutomatedBackup(Boolean var1);

        public Builder endpoint(String var1);

        public Builder engine(String var1);

        public Builder engineModel(String var1);

        public Builder engineAttributes(Collection<EngineAttribute> var1);

        public Builder engineAttributes(EngineAttribute ... var1);

        public Builder engineVersion(String var1);

        public Builder instanceProfileArn(String var1);

        public Builder instanceType(String var1);

        public Builder keyPair(String var1);

        public Builder maintenanceStatus(String var1);

        public Builder maintenanceStatus(MaintenanceStatus var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder preferredBackupWindow(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder serviceRoleArn(String var1);

        public Builder status(String var1);

        public Builder status(ServerStatus var1);

        public Builder statusReason(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder serverArn(String var1);
    }
}

