/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeBackupsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeBackupsRequest> {
    private final String backupId;
    private final String serverName;
    private final String nextToken;
    private final Integer maxResults;

    private DescribeBackupsRequest(BuilderImpl builder) {
        this.backupId = builder.backupId;
        this.serverName = builder.serverName;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public String backupId() {
        return this.backupId;
    }

    public String serverName() {
        return this.serverName;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.backupId() == null ? 0 : this.backupId().hashCode());
        hashCode = 31 * hashCode + (this.serverName() == null ? 0 : this.serverName().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBackupsRequest)) {
            return false;
        }
        DescribeBackupsRequest other = (DescribeBackupsRequest)((Object)obj);
        if (other.backupId() == null ^ this.backupId() == null) {
            return false;
        }
        if (other.backupId() != null && !other.backupId().equals(this.backupId())) {
            return false;
        }
        if (other.serverName() == null ^ this.serverName() == null) {
            return false;
        }
        if (other.serverName() != null && !other.serverName().equals(this.serverName())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        return other.maxResults() == null || other.maxResults().equals(this.maxResults());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.backupId() != null) {
            sb.append("BackupId: ").append(this.backupId()).append(",");
        }
        if (this.serverName() != null) {
            sb.append("ServerName: ").append(this.serverName()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupId": {
                return Optional.of(clazz.cast(this.backupId()));
            }
            case "ServerName": {
                return Optional.of(clazz.cast(this.serverName()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String backupId;
        private String serverName;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBackupsRequest model) {
            this.backupId(model.backupId);
            this.serverName(model.serverName);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getBackupId() {
            return this.backupId;
        }

        @Override
        public final Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        public final void setBackupId(String backupId) {
            this.backupId = backupId;
        }

        public final String getServerName() {
            return this.serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public DescribeBackupsRequest build() {
            return new DescribeBackupsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeBackupsRequest> {
        public Builder backupId(String var1);

        public Builder serverName(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);
    }
}

