/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworkscm.transform.ServerEventMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ServerEvent
implements StructuredPojo,
ToCopyableBuilder<Builder, ServerEvent> {
    private final Instant createdAt;
    private final String serverName;
    private final String message;
    private final String logUrl;

    private ServerEvent(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.serverName = builder.serverName;
        this.message = builder.message;
        this.logUrl = builder.logUrl;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public String serverName() {
        return this.serverName;
    }

    public String message() {
        return this.message;
    }

    public String logUrl() {
        return this.logUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.createdAt() == null ? 0 : this.createdAt().hashCode());
        hashCode = 31 * hashCode + (this.serverName() == null ? 0 : this.serverName().hashCode());
        hashCode = 31 * hashCode + (this.message() == null ? 0 : this.message().hashCode());
        hashCode = 31 * hashCode + (this.logUrl() == null ? 0 : this.logUrl().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerEvent)) {
            return false;
        }
        ServerEvent other = (ServerEvent)obj;
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        if (other.createdAt() != null && !other.createdAt().equals(this.createdAt())) {
            return false;
        }
        if (other.serverName() == null ^ this.serverName() == null) {
            return false;
        }
        if (other.serverName() != null && !other.serverName().equals(this.serverName())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.logUrl() == null ^ this.logUrl() == null) {
            return false;
        }
        return other.logUrl() == null || other.logUrl().equals(this.logUrl());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.createdAt() != null) {
            sb.append("CreatedAt: ").append(this.createdAt()).append(",");
        }
        if (this.serverName() != null) {
            sb.append("ServerName: ").append(this.serverName()).append(",");
        }
        if (this.message() != null) {
            sb.append("Message: ").append(this.message()).append(",");
        }
        if (this.logUrl() != null) {
            sb.append("LogUrl: ").append(this.logUrl()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ServerEventMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String serverName;
        private String message;
        private String logUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerEvent model) {
            this.setCreatedAt(model.createdAt);
            this.setServerName(model.serverName);
            this.setMessage(model.message);
            this.setLogUrl(model.logUrl);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getServerName() {
            return this.serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getLogUrl() {
            return this.logUrl;
        }

        @Override
        public final Builder logUrl(String logUrl) {
            this.logUrl = logUrl;
            return this;
        }

        public final void setLogUrl(String logUrl) {
            this.logUrl = logUrl;
        }

        public ServerEvent build() {
            return new ServerEvent(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ServerEvent> {
        public Builder createdAt(Instant var1);

        public Builder serverName(String var1);

        public Builder message(String var1);

        public Builder logUrl(String var1);
    }
}

