/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.opsworkscm.model.AccountAttribute;
import software.amazon.awssdk.services.opsworkscm.model.AccountAttributesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAccountAttributesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeAccountAttributesResponse> {
    private final List<AccountAttribute> attributes;

    private DescribeAccountAttributesResponse(BuilderImpl builder) {
        this.attributes = builder.attributes;
    }

    public List<AccountAttribute> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attributes() == null ? 0 : this.attributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountAttributesResponse)) {
            return false;
        }
        DescribeAccountAttributesResponse other = (DescribeAccountAttributesResponse)((Object)obj);
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        return other.attributes() == null || other.attributes().equals(this.attributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<AccountAttribute> attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountAttributesResponse model) {
            this.setAttributes(model.attributes);
        }

        public final Collection<AccountAttribute> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Collection<AccountAttribute> attributes) {
            this.attributes = AccountAttributesCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(AccountAttribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        public final void setAttributes(Collection<AccountAttribute> attributes) {
            this.attributes = AccountAttributesCopier.copy(attributes);
        }

        public DescribeAccountAttributesResponse build() {
            return new DescribeAccountAttributesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeAccountAttributesResponse> {
        public Builder attributes(Collection<AccountAttribute> var1);

        public Builder attributes(AccountAttribute ... var1);
    }
}

