/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworkscm.transform.AccountAttributeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AccountAttribute
implements StructuredPojo,
ToCopyableBuilder<Builder, AccountAttribute> {
    private final String name;
    private final Integer maximum;
    private final Integer used;

    private AccountAttribute(BuilderImpl builder) {
        this.name = builder.name;
        this.maximum = builder.maximum;
        this.used = builder.used;
    }

    public String name() {
        return this.name;
    }

    public Integer maximum() {
        return this.maximum;
    }

    public Integer used() {
        return this.used;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.maximum() == null ? 0 : this.maximum().hashCode());
        hashCode = 31 * hashCode + (this.used() == null ? 0 : this.used().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountAttribute)) {
            return false;
        }
        AccountAttribute other = (AccountAttribute)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.maximum() == null ^ this.maximum() == null) {
            return false;
        }
        if (other.maximum() != null && !other.maximum().equals(this.maximum())) {
            return false;
        }
        if (other.used() == null ^ this.used() == null) {
            return false;
        }
        return other.used() == null || other.used().equals(this.used());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.maximum() != null) {
            sb.append("Maximum: ").append(this.maximum()).append(",");
        }
        if (this.used() != null) {
            sb.append("Used: ").append(this.used()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AccountAttributeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private Integer maximum;
        private Integer used;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountAttribute model) {
            this.setName(model.name);
            this.setMaximum(model.maximum);
            this.setUsed(model.used);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getMaximum() {
            return this.maximum;
        }

        @Override
        public final Builder maximum(Integer maximum) {
            this.maximum = maximum;
            return this;
        }

        public final void setMaximum(Integer maximum) {
            this.maximum = maximum;
        }

        public final Integer getUsed() {
            return this.used;
        }

        @Override
        public final Builder used(Integer used) {
            this.used = used;
            return this;
        }

        public final void setUsed(Integer used) {
            this.used = used;
        }

        public AccountAttribute build() {
            return new AccountAttribute(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AccountAttribute> {
        public Builder name(String var1);

        public Builder maximum(Integer var1);

        public Builder used(Integer var1);
    }
}

