/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm;

import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandler;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkClientHandler;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.opsworkscm.OpsWorksCMClient;
import software.amazon.awssdk.services.opsworkscm.model.AssociateNodeRequest;
import software.amazon.awssdk.services.opsworkscm.model.AssociateNodeResponse;
import software.amazon.awssdk.services.opsworkscm.model.CreateBackupRequest;
import software.amazon.awssdk.services.opsworkscm.model.CreateBackupResponse;
import software.amazon.awssdk.services.opsworkscm.model.CreateServerRequest;
import software.amazon.awssdk.services.opsworkscm.model.CreateServerResponse;
import software.amazon.awssdk.services.opsworkscm.model.DeleteBackupRequest;
import software.amazon.awssdk.services.opsworkscm.model.DeleteBackupResponse;
import software.amazon.awssdk.services.opsworkscm.model.DeleteServerRequest;
import software.amazon.awssdk.services.opsworkscm.model.DeleteServerResponse;
import software.amazon.awssdk.services.opsworkscm.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.opsworkscm.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.opsworkscm.model.DescribeBackupsRequest;
import software.amazon.awssdk.services.opsworkscm.model.DescribeBackupsResponse;
import software.amazon.awssdk.services.opsworkscm.model.DescribeEventsRequest;
import software.amazon.awssdk.services.opsworkscm.model.DescribeEventsResponse;
import software.amazon.awssdk.services.opsworkscm.model.DescribeNodeAssociationStatusRequest;
import software.amazon.awssdk.services.opsworkscm.model.DescribeNodeAssociationStatusResponse;
import software.amazon.awssdk.services.opsworkscm.model.DescribeServersRequest;
import software.amazon.awssdk.services.opsworkscm.model.DescribeServersResponse;
import software.amazon.awssdk.services.opsworkscm.model.DisassociateNodeRequest;
import software.amazon.awssdk.services.opsworkscm.model.DisassociateNodeResponse;
import software.amazon.awssdk.services.opsworkscm.model.InvalidNextTokenException;
import software.amazon.awssdk.services.opsworkscm.model.InvalidStateException;
import software.amazon.awssdk.services.opsworkscm.model.LimitExceededException;
import software.amazon.awssdk.services.opsworkscm.model.OpsWorksCMException;
import software.amazon.awssdk.services.opsworkscm.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.opsworkscm.model.ResourceNotFoundException;
import software.amazon.awssdk.services.opsworkscm.model.RestoreServerRequest;
import software.amazon.awssdk.services.opsworkscm.model.RestoreServerResponse;
import software.amazon.awssdk.services.opsworkscm.model.StartMaintenanceRequest;
import software.amazon.awssdk.services.opsworkscm.model.StartMaintenanceResponse;
import software.amazon.awssdk.services.opsworkscm.model.UpdateServerEngineAttributesRequest;
import software.amazon.awssdk.services.opsworkscm.model.UpdateServerEngineAttributesResponse;
import software.amazon.awssdk.services.opsworkscm.model.UpdateServerRequest;
import software.amazon.awssdk.services.opsworkscm.model.UpdateServerResponse;
import software.amazon.awssdk.services.opsworkscm.model.ValidationException;
import software.amazon.awssdk.services.opsworkscm.transform.AssociateNodeRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.AssociateNodeResponseUnmarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.CreateBackupRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.CreateBackupResponseUnmarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.CreateServerRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.CreateServerResponseUnmarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DeleteBackupRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DeleteBackupResponseUnmarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DeleteServerRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DeleteServerResponseUnmarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DescribeAccountAttributesRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DescribeAccountAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DescribeBackupsRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DescribeBackupsResponseUnmarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DescribeEventsResponseUnmarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DescribeNodeAssociationStatusRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DescribeNodeAssociationStatusResponseUnmarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DescribeServersRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DescribeServersResponseUnmarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DisassociateNodeRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.DisassociateNodeResponseUnmarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.RestoreServerRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.RestoreServerResponseUnmarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.StartMaintenanceRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.StartMaintenanceResponseUnmarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.UpdateServerEngineAttributesRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.UpdateServerEngineAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.UpdateServerRequestMarshaller;
import software.amazon.awssdk.services.opsworkscm.transform.UpdateServerResponseUnmarshaller;

@SdkInternalApi
final class DefaultOpsWorksCMClient
implements OpsWorksCMClient {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final AwsSyncClientParams clientParams;

    protected DefaultOpsWorksCMClient(AwsSyncClientParams clientParams) {
        this.clientHandler = new SdkClientHandler(new ClientHandlerParams().withClientParams(clientParams).withCalculateCrc32FromCompressedDataEnabled(false));
        this.clientParams = clientParams;
        this.protocolFactory = this.init();
    }

    @Override
    public AssociateNodeResponse associateNode(AssociateNodeRequest associateNodeRequest) throws InvalidStateException, ResourceNotFoundException, ValidationException, SdkBaseException, SdkClientException, OpsWorksCMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new AssociateNodeResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (AssociateNodeResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)associateNodeRequest).withMarshaller((Marshaller)new AssociateNodeRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public CreateBackupResponse createBackup(CreateBackupRequest createBackupRequest) throws InvalidStateException, LimitExceededException, ResourceNotFoundException, ValidationException, SdkBaseException, SdkClientException, OpsWorksCMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreateBackupResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateBackupResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createBackupRequest).withMarshaller((Marshaller)new CreateBackupRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public CreateServerResponse createServer(CreateServerRequest createServerRequest) throws LimitExceededException, ResourceAlreadyExistsException, ResourceNotFoundException, ValidationException, SdkBaseException, SdkClientException, OpsWorksCMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreateServerResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateServerResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createServerRequest).withMarshaller((Marshaller)new CreateServerRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeleteBackupResponse deleteBackup(DeleteBackupRequest deleteBackupRequest) throws InvalidStateException, ResourceNotFoundException, ValidationException, SdkBaseException, SdkClientException, OpsWorksCMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteBackupResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteBackupResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteBackupRequest).withMarshaller((Marshaller)new DeleteBackupRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeleteServerResponse deleteServer(DeleteServerRequest deleteServerRequest) throws InvalidStateException, ResourceNotFoundException, ValidationException, SdkBaseException, SdkClientException, OpsWorksCMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteServerResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteServerResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteServerRequest).withMarshaller((Marshaller)new DeleteServerRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeAccountAttributesResponse describeAccountAttributes() throws SdkBaseException, SdkClientException, OpsWorksCMException {
        return this.describeAccountAttributes((DescribeAccountAttributesRequest)((Object)DescribeAccountAttributesRequest.builder().build()));
    }

    @Override
    public DescribeAccountAttributesResponse describeAccountAttributes(DescribeAccountAttributesRequest describeAccountAttributesRequest) throws SdkBaseException, SdkClientException, OpsWorksCMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeAccountAttributesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeAccountAttributesResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeAccountAttributesRequest).withMarshaller((Marshaller)new DescribeAccountAttributesRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeBackupsResponse describeBackups() throws ValidationException, ResourceNotFoundException, InvalidNextTokenException, SdkBaseException, SdkClientException, OpsWorksCMException {
        return this.describeBackups((DescribeBackupsRequest)((Object)DescribeBackupsRequest.builder().build()));
    }

    @Override
    public DescribeBackupsResponse describeBackups(DescribeBackupsRequest describeBackupsRequest) throws ValidationException, ResourceNotFoundException, InvalidNextTokenException, SdkBaseException, SdkClientException, OpsWorksCMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeBackupsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeBackupsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeBackupsRequest).withMarshaller((Marshaller)new DescribeBackupsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeEventsResponse describeEvents(DescribeEventsRequest describeEventsRequest) throws ValidationException, InvalidNextTokenException, ResourceNotFoundException, SdkBaseException, SdkClientException, OpsWorksCMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeEventsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeEventsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeEventsRequest).withMarshaller((Marshaller)new DescribeEventsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeNodeAssociationStatusResponse describeNodeAssociationStatus(DescribeNodeAssociationStatusRequest describeNodeAssociationStatusRequest) throws ResourceNotFoundException, ValidationException, SdkBaseException, SdkClientException, OpsWorksCMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeNodeAssociationStatusResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeNodeAssociationStatusResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeNodeAssociationStatusRequest).withMarshaller((Marshaller)new DescribeNodeAssociationStatusRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DescribeServersResponse describeServers() throws ValidationException, ResourceNotFoundException, InvalidNextTokenException, SdkBaseException, SdkClientException, OpsWorksCMException {
        return this.describeServers((DescribeServersRequest)((Object)DescribeServersRequest.builder().build()));
    }

    @Override
    public DescribeServersResponse describeServers(DescribeServersRequest describeServersRequest) throws ValidationException, ResourceNotFoundException, InvalidNextTokenException, SdkBaseException, SdkClientException, OpsWorksCMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeServersResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeServersResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeServersRequest).withMarshaller((Marshaller)new DescribeServersRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DisassociateNodeResponse disassociateNode(DisassociateNodeRequest disassociateNodeRequest) throws InvalidStateException, ResourceNotFoundException, ValidationException, SdkBaseException, SdkClientException, OpsWorksCMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DisassociateNodeResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DisassociateNodeResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)disassociateNodeRequest).withMarshaller((Marshaller)new DisassociateNodeRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public RestoreServerResponse restoreServer(RestoreServerRequest restoreServerRequest) throws InvalidStateException, ResourceNotFoundException, ValidationException, SdkBaseException, SdkClientException, OpsWorksCMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new RestoreServerResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (RestoreServerResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)restoreServerRequest).withMarshaller((Marshaller)new RestoreServerRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public StartMaintenanceResponse startMaintenance(StartMaintenanceRequest startMaintenanceRequest) throws InvalidStateException, ResourceNotFoundException, ValidationException, SdkBaseException, SdkClientException, OpsWorksCMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new StartMaintenanceResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (StartMaintenanceResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)startMaintenanceRequest).withMarshaller((Marshaller)new StartMaintenanceRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public UpdateServerResponse updateServer(UpdateServerRequest updateServerRequest) throws InvalidStateException, ResourceNotFoundException, ValidationException, SdkBaseException, SdkClientException, OpsWorksCMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UpdateServerResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateServerResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)updateServerRequest).withMarshaller((Marshaller)new UpdateServerRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public UpdateServerEngineAttributesResponse updateServerEngineAttributes(UpdateServerEngineAttributesRequest updateServerEngineAttributesRequest) throws InvalidStateException, ResourceNotFoundException, ValidationException, SdkBaseException, SdkClientException, OpsWorksCMException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UpdateServerEngineAttributesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateServerEngineAttributesResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)updateServerEngineAttributesRequest).withMarshaller((Marshaller)new UpdateServerEngineAttributesRequestMarshaller(this.protocolFactory))));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(OpsWorksCMException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withModeledClass(ValidationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceAlreadyExistsException").withModeledClass(ResourceAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidStateException").withModeledClass(InvalidStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withModeledClass(InvalidNextTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)));
    }

    @Override
    public void close() throws Exception {
        this.clientHandler.close();
    }
}

