/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.opsworkscm.model.OpsWorksCMRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateBackupRequest
extends OpsWorksCMRequest
implements ToCopyableBuilder<Builder, CreateBackupRequest> {
    private final String serverName;
    private final String description;

    private CreateBackupRequest(BuilderImpl builder) {
        super(builder);
        this.serverName = builder.serverName;
        this.description = builder.description;
    }

    public String serverName() {
        return this.serverName;
    }

    public String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBackupRequest)) {
            return false;
        }
        CreateBackupRequest other = (CreateBackupRequest)((Object)obj);
        return Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"CreateBackupRequest").add("ServerName", (Object)this.serverName()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServerName": {
                return Optional.of(clazz.cast(this.serverName()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksCMRequest.BuilderImpl
    implements Builder {
        private String serverName;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBackupRequest model) {
            super(model);
            this.serverName(model.serverName);
            this.description(model.description);
        }

        public final String getServerName() {
            return this.serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateBackupRequest build() {
            return new CreateBackupRequest(this);
        }
    }

    public static interface Builder
    extends OpsWorksCMRequest.Builder,
    CopyableBuilder<Builder, CreateBackupRequest> {
        public Builder serverName(String var1);

        public Builder description(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

