/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.opsworkscm.model.Server;
import software.amazon.awssdk.services.opsworkscm.model.ServersCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeServersResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeServersResponse> {
    private final List<Server> servers;
    private final String nextToken;

    private DescribeServersResponse(BuilderImpl builder) {
        this.servers = builder.servers;
        this.nextToken = builder.nextToken;
    }

    public List<Server> servers() {
        return this.servers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.servers() == null ? 0 : this.servers().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServersResponse)) {
            return false;
        }
        DescribeServersResponse other = (DescribeServersResponse)((Object)obj);
        if (other.servers() == null ^ this.servers() == null) {
            return false;
        }
        if (other.servers() != null && !other.servers().equals(this.servers())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.servers() != null) {
            sb.append("Servers: ").append(this.servers()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Server> servers;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServersResponse model) {
            this.setServers(model.servers);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Server> getServers() {
            return this.servers;
        }

        @Override
        public final Builder servers(Collection<Server> servers) {
            this.servers = ServersCopier.copy(servers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder servers(Server ... servers) {
            if (this.servers == null) {
                this.servers = new ArrayList<Server>(servers.length);
            }
            for (Server e : servers) {
                this.servers.add(e);
            }
            return this;
        }

        public final void setServers(Collection<Server> servers) {
            this.servers = ServersCopier.copy(servers);
        }

        @SafeVarargs
        public final void setServers(Server ... servers) {
            if (this.servers == null) {
                this.servers = new ArrayList<Server>(servers.length);
            }
            for (Server e : servers) {
                this.servers.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeServersResponse build() {
            return new DescribeServersResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeServersResponse> {
        public Builder servers(Collection<Server> var1);

        public Builder servers(Server ... var1);

        public Builder nextToken(String var1);
    }
}

