/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.opsworkscm.model.EngineAttribute;
import software.amazon.awssdk.services.opsworkscm.model.EngineAttributesCopier;
import software.amazon.awssdk.services.opsworkscm.model.StringsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateServerRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateServerRequest> {
    private final Boolean associatePublicIpAddress;
    private final Boolean disableAutomatedBackup;
    private final String engine;
    private final String engineModel;
    private final String engineVersion;
    private final List<EngineAttribute> engineAttributes;
    private final Integer backupRetentionCount;
    private final String serverName;
    private final String instanceProfileArn;
    private final String instanceType;
    private final String keyPair;
    private final String preferredMaintenanceWindow;
    private final String preferredBackupWindow;
    private final List<String> securityGroupIds;
    private final String serviceRoleArn;
    private final List<String> subnetIds;
    private final String backupId;

    private CreateServerRequest(BuilderImpl builder) {
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.disableAutomatedBackup = builder.disableAutomatedBackup;
        this.engine = builder.engine;
        this.engineModel = builder.engineModel;
        this.engineVersion = builder.engineVersion;
        this.engineAttributes = builder.engineAttributes;
        this.backupRetentionCount = builder.backupRetentionCount;
        this.serverName = builder.serverName;
        this.instanceProfileArn = builder.instanceProfileArn;
        this.instanceType = builder.instanceType;
        this.keyPair = builder.keyPair;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.securityGroupIds = builder.securityGroupIds;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.subnetIds = builder.subnetIds;
        this.backupId = builder.backupId;
    }

    public Boolean associatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }

    public Boolean disableAutomatedBackup() {
        return this.disableAutomatedBackup;
    }

    public String engine() {
        return this.engine;
    }

    public String engineModel() {
        return this.engineModel;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public List<EngineAttribute> engineAttributes() {
        return this.engineAttributes;
    }

    public Integer backupRetentionCount() {
        return this.backupRetentionCount;
    }

    public String serverName() {
        return this.serverName;
    }

    public String instanceProfileArn() {
        return this.instanceProfileArn;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public String keyPair() {
        return this.keyPair;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public String preferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public String serviceRoleArn() {
        return this.serviceRoleArn;
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public String backupId() {
        return this.backupId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.associatePublicIpAddress() == null ? 0 : this.associatePublicIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.disableAutomatedBackup() == null ? 0 : this.disableAutomatedBackup().hashCode());
        hashCode = 31 * hashCode + (this.engine() == null ? 0 : this.engine().hashCode());
        hashCode = 31 * hashCode + (this.engineModel() == null ? 0 : this.engineModel().hashCode());
        hashCode = 31 * hashCode + (this.engineVersion() == null ? 0 : this.engineVersion().hashCode());
        hashCode = 31 * hashCode + (this.engineAttributes() == null ? 0 : this.engineAttributes().hashCode());
        hashCode = 31 * hashCode + (this.backupRetentionCount() == null ? 0 : this.backupRetentionCount().hashCode());
        hashCode = 31 * hashCode + (this.serverName() == null ? 0 : this.serverName().hashCode());
        hashCode = 31 * hashCode + (this.instanceProfileArn() == null ? 0 : this.instanceProfileArn().hashCode());
        hashCode = 31 * hashCode + (this.instanceType() == null ? 0 : this.instanceType().hashCode());
        hashCode = 31 * hashCode + (this.keyPair() == null ? 0 : this.keyPair().hashCode());
        hashCode = 31 * hashCode + (this.preferredMaintenanceWindow() == null ? 0 : this.preferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.preferredBackupWindow() == null ? 0 : this.preferredBackupWindow().hashCode());
        hashCode = 31 * hashCode + (this.securityGroupIds() == null ? 0 : this.securityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.serviceRoleArn() == null ? 0 : this.serviceRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.subnetIds() == null ? 0 : this.subnetIds().hashCode());
        hashCode = 31 * hashCode + (this.backupId() == null ? 0 : this.backupId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServerRequest)) {
            return false;
        }
        CreateServerRequest other = (CreateServerRequest)((Object)obj);
        if (other.associatePublicIpAddress() == null ^ this.associatePublicIpAddress() == null) {
            return false;
        }
        if (other.associatePublicIpAddress() != null && !other.associatePublicIpAddress().equals(this.associatePublicIpAddress())) {
            return false;
        }
        if (other.disableAutomatedBackup() == null ^ this.disableAutomatedBackup() == null) {
            return false;
        }
        if (other.disableAutomatedBackup() != null && !other.disableAutomatedBackup().equals(this.disableAutomatedBackup())) {
            return false;
        }
        if (other.engine() == null ^ this.engine() == null) {
            return false;
        }
        if (other.engine() != null && !other.engine().equals(this.engine())) {
            return false;
        }
        if (other.engineModel() == null ^ this.engineModel() == null) {
            return false;
        }
        if (other.engineModel() != null && !other.engineModel().equals(this.engineModel())) {
            return false;
        }
        if (other.engineVersion() == null ^ this.engineVersion() == null) {
            return false;
        }
        if (other.engineVersion() != null && !other.engineVersion().equals(this.engineVersion())) {
            return false;
        }
        if (other.engineAttributes() == null ^ this.engineAttributes() == null) {
            return false;
        }
        if (other.engineAttributes() != null && !other.engineAttributes().equals(this.engineAttributes())) {
            return false;
        }
        if (other.backupRetentionCount() == null ^ this.backupRetentionCount() == null) {
            return false;
        }
        if (other.backupRetentionCount() != null && !other.backupRetentionCount().equals(this.backupRetentionCount())) {
            return false;
        }
        if (other.serverName() == null ^ this.serverName() == null) {
            return false;
        }
        if (other.serverName() != null && !other.serverName().equals(this.serverName())) {
            return false;
        }
        if (other.instanceProfileArn() == null ^ this.instanceProfileArn() == null) {
            return false;
        }
        if (other.instanceProfileArn() != null && !other.instanceProfileArn().equals(this.instanceProfileArn())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.keyPair() == null ^ this.keyPair() == null) {
            return false;
        }
        if (other.keyPair() != null && !other.keyPair().equals(this.keyPair())) {
            return false;
        }
        if (other.preferredMaintenanceWindow() == null ^ this.preferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.preferredMaintenanceWindow() != null && !other.preferredMaintenanceWindow().equals(this.preferredMaintenanceWindow())) {
            return false;
        }
        if (other.preferredBackupWindow() == null ^ this.preferredBackupWindow() == null) {
            return false;
        }
        if (other.preferredBackupWindow() != null && !other.preferredBackupWindow().equals(this.preferredBackupWindow())) {
            return false;
        }
        if (other.securityGroupIds() == null ^ this.securityGroupIds() == null) {
            return false;
        }
        if (other.securityGroupIds() != null && !other.securityGroupIds().equals(this.securityGroupIds())) {
            return false;
        }
        if (other.serviceRoleArn() == null ^ this.serviceRoleArn() == null) {
            return false;
        }
        if (other.serviceRoleArn() != null && !other.serviceRoleArn().equals(this.serviceRoleArn())) {
            return false;
        }
        if (other.subnetIds() == null ^ this.subnetIds() == null) {
            return false;
        }
        if (other.subnetIds() != null && !other.subnetIds().equals(this.subnetIds())) {
            return false;
        }
        if (other.backupId() == null ^ this.backupId() == null) {
            return false;
        }
        return other.backupId() == null || other.backupId().equals(this.backupId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.associatePublicIpAddress() != null) {
            sb.append("AssociatePublicIpAddress: ").append(this.associatePublicIpAddress()).append(",");
        }
        if (this.disableAutomatedBackup() != null) {
            sb.append("DisableAutomatedBackup: ").append(this.disableAutomatedBackup()).append(",");
        }
        if (this.engine() != null) {
            sb.append("Engine: ").append(this.engine()).append(",");
        }
        if (this.engineModel() != null) {
            sb.append("EngineModel: ").append(this.engineModel()).append(",");
        }
        if (this.engineVersion() != null) {
            sb.append("EngineVersion: ").append(this.engineVersion()).append(",");
        }
        if (this.engineAttributes() != null) {
            sb.append("EngineAttributes: ").append(this.engineAttributes()).append(",");
        }
        if (this.backupRetentionCount() != null) {
            sb.append("BackupRetentionCount: ").append(this.backupRetentionCount()).append(",");
        }
        if (this.serverName() != null) {
            sb.append("ServerName: ").append(this.serverName()).append(",");
        }
        if (this.instanceProfileArn() != null) {
            sb.append("InstanceProfileArn: ").append(this.instanceProfileArn()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.keyPair() != null) {
            sb.append("KeyPair: ").append(this.keyPair()).append(",");
        }
        if (this.preferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: ").append(this.preferredMaintenanceWindow()).append(",");
        }
        if (this.preferredBackupWindow() != null) {
            sb.append("PreferredBackupWindow: ").append(this.preferredBackupWindow()).append(",");
        }
        if (this.securityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(this.securityGroupIds()).append(",");
        }
        if (this.serviceRoleArn() != null) {
            sb.append("ServiceRoleArn: ").append(this.serviceRoleArn()).append(",");
        }
        if (this.subnetIds() != null) {
            sb.append("SubnetIds: ").append(this.subnetIds()).append(",");
        }
        if (this.backupId() != null) {
            sb.append("BackupId: ").append(this.backupId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Boolean associatePublicIpAddress;
        private Boolean disableAutomatedBackup;
        private String engine;
        private String engineModel;
        private String engineVersion;
        private List<EngineAttribute> engineAttributes;
        private Integer backupRetentionCount;
        private String serverName;
        private String instanceProfileArn;
        private String instanceType;
        private String keyPair;
        private String preferredMaintenanceWindow;
        private String preferredBackupWindow;
        private List<String> securityGroupIds;
        private String serviceRoleArn;
        private List<String> subnetIds;
        private String backupId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServerRequest model) {
            this.setAssociatePublicIpAddress(model.associatePublicIpAddress);
            this.setDisableAutomatedBackup(model.disableAutomatedBackup);
            this.setEngine(model.engine);
            this.setEngineModel(model.engineModel);
            this.setEngineVersion(model.engineVersion);
            this.setEngineAttributes(model.engineAttributes);
            this.setBackupRetentionCount(model.backupRetentionCount);
            this.setServerName(model.serverName);
            this.setInstanceProfileArn(model.instanceProfileArn);
            this.setInstanceType(model.instanceType);
            this.setKeyPair(model.keyPair);
            this.setPreferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.setPreferredBackupWindow(model.preferredBackupWindow);
            this.setSecurityGroupIds(model.securityGroupIds);
            this.setServiceRoleArn(model.serviceRoleArn);
            this.setSubnetIds(model.subnetIds);
            this.setBackupId(model.backupId);
        }

        public final Boolean getAssociatePublicIpAddress() {
            return this.associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        public final Boolean getDisableAutomatedBackup() {
            return this.disableAutomatedBackup;
        }

        @Override
        public final Builder disableAutomatedBackup(Boolean disableAutomatedBackup) {
            this.disableAutomatedBackup = disableAutomatedBackup;
            return this;
        }

        public final void setDisableAutomatedBackup(Boolean disableAutomatedBackup) {
            this.disableAutomatedBackup = disableAutomatedBackup;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineModel() {
            return this.engineModel;
        }

        @Override
        public final Builder engineModel(String engineModel) {
            this.engineModel = engineModel;
            return this;
        }

        public final void setEngineModel(String engineModel) {
            this.engineModel = engineModel;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Collection<EngineAttribute> getEngineAttributes() {
            return this.engineAttributes;
        }

        @Override
        public final Builder engineAttributes(Collection<EngineAttribute> engineAttributes) {
            this.engineAttributes = EngineAttributesCopier.copy(engineAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineAttributes(EngineAttribute ... engineAttributes) {
            if (this.engineAttributes == null) {
                this.engineAttributes = new ArrayList<EngineAttribute>(engineAttributes.length);
            }
            for (EngineAttribute e : engineAttributes) {
                this.engineAttributes.add(e);
            }
            return this;
        }

        public final void setEngineAttributes(Collection<EngineAttribute> engineAttributes) {
            this.engineAttributes = EngineAttributesCopier.copy(engineAttributes);
        }

        @SafeVarargs
        public final void setEngineAttributes(EngineAttribute ... engineAttributes) {
            if (this.engineAttributes == null) {
                this.engineAttributes = new ArrayList<EngineAttribute>(engineAttributes.length);
            }
            for (EngineAttribute e : engineAttributes) {
                this.engineAttributes.add(e);
            }
        }

        public final Integer getBackupRetentionCount() {
            return this.backupRetentionCount;
        }

        @Override
        public final Builder backupRetentionCount(Integer backupRetentionCount) {
            this.backupRetentionCount = backupRetentionCount;
            return this;
        }

        public final void setBackupRetentionCount(Integer backupRetentionCount) {
            this.backupRetentionCount = backupRetentionCount;
        }

        public final String getServerName() {
            return this.serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final String getInstanceProfileArn() {
            return this.instanceProfileArn;
        }

        @Override
        public final Builder instanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
            return this;
        }

        public final void setInstanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKeyPair() {
            return this.keyPair;
        }

        @Override
        public final Builder keyPair(String keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public final void setKeyPair(String keyPair) {
            this.keyPair = keyPair;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            if (this.securityGroupIds == null) {
                this.securityGroupIds = new ArrayList<String>(securityGroupIds.length);
            }
            for (String e : securityGroupIds) {
                this.securityGroupIds.add(e);
            }
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringsCopier.copy(securityGroupIds);
        }

        @SafeVarargs
        public final void setSecurityGroupIds(String ... securityGroupIds) {
            if (this.securityGroupIds == null) {
                this.securityGroupIds = new ArrayList<String>(securityGroupIds.length);
            }
            for (String e : securityGroupIds) {
                this.securityGroupIds.add(e);
            }
        }

        public final String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final Collection<String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            if (this.subnetIds == null) {
                this.subnetIds = new ArrayList<String>(subnetIds.length);
            }
            for (String e : subnetIds) {
                this.subnetIds.add(e);
            }
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringsCopier.copy(subnetIds);
        }

        @SafeVarargs
        public final void setSubnetIds(String ... subnetIds) {
            if (this.subnetIds == null) {
                this.subnetIds = new ArrayList<String>(subnetIds.length);
            }
            for (String e : subnetIds) {
                this.subnetIds.add(e);
            }
        }

        public final String getBackupId() {
            return this.backupId;
        }

        @Override
        public final Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        public final void setBackupId(String backupId) {
            this.backupId = backupId;
        }

        public CreateServerRequest build() {
            return new CreateServerRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateServerRequest> {
        public Builder associatePublicIpAddress(Boolean var1);

        public Builder disableAutomatedBackup(Boolean var1);

        public Builder engine(String var1);

        public Builder engineModel(String var1);

        public Builder engineVersion(String var1);

        public Builder engineAttributes(Collection<EngineAttribute> var1);

        public Builder engineAttributes(EngineAttribute ... var1);

        public Builder backupRetentionCount(Integer var1);

        public Builder serverName(String var1);

        public Builder instanceProfileArn(String var1);

        public Builder instanceType(String var1);

        public Builder keyPair(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder preferredBackupWindow(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder serviceRoleArn(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder backupId(String var1);
    }
}

