/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.OpsWorksResponse;
import software.amazon.awssdk.services.opsworks.model.UserProfile;
import software.amazon.awssdk.services.opsworks.model.UserProfilesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeUserProfilesResponse
extends OpsWorksResponse
implements ToCopyableBuilder<Builder, DescribeUserProfilesResponse> {
    private static final SdkField<List<UserProfile>> USER_PROFILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeUserProfilesResponse.getter(DescribeUserProfilesResponse::userProfiles)).setter(DescribeUserProfilesResponse.setter(Builder::userProfiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProfiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserProfile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_PROFILES_FIELD));
    private final List<UserProfile> userProfiles;

    private DescribeUserProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.userProfiles = builder.userProfiles;
    }

    public List<UserProfile> userProfiles() {
        return this.userProfiles;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userProfiles());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserProfilesResponse)) {
            return false;
        }
        DescribeUserProfilesResponse other = (DescribeUserProfilesResponse)((Object)obj);
        return Objects.equals(this.userProfiles(), other.userProfiles());
    }

    public String toString() {
        return ToString.builder((String)"DescribeUserProfilesResponse").add("UserProfiles", this.userProfiles()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserProfiles": {
                return Optional.ofNullable(clazz.cast(this.userProfiles()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUserProfilesResponse, T> g) {
        return obj -> g.apply((DescribeUserProfilesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksResponse.BuilderImpl
    implements Builder {
        private List<UserProfile> userProfiles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserProfilesResponse model) {
            super(model);
            this.userProfiles(model.userProfiles);
        }

        public final Collection<UserProfile.Builder> getUserProfiles() {
            return this.userProfiles != null ? (Collection)this.userProfiles.stream().map(UserProfile::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userProfiles(Collection<UserProfile> userProfiles) {
            this.userProfiles = UserProfilesCopier.copy(userProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userProfiles(UserProfile ... userProfiles) {
            this.userProfiles(Arrays.asList(userProfiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userProfiles(Consumer<UserProfile.Builder> ... userProfiles) {
            this.userProfiles(Stream.of(userProfiles).map(c -> (UserProfile)((UserProfile.Builder)UserProfile.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserProfiles(Collection<UserProfile.BuilderImpl> userProfiles) {
            this.userProfiles = UserProfilesCopier.copyFromBuilder(userProfiles);
        }

        @Override
        public DescribeUserProfilesResponse build() {
            return new DescribeUserProfilesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpsWorksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeUserProfilesResponse> {
        public Builder userProfiles(Collection<UserProfile> var1);

        public Builder userProfiles(UserProfile ... var1);

        public Builder userProfiles(Consumer<UserProfile.Builder> ... var1);
    }
}

