/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opsworks.model.InstancesCount;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StackSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StackSummary> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackId").getter(StackSummary.getter(StackSummary::stackId)).setter(StackSummary.setter(Builder::stackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(StackSummary.getter(StackSummary::name)).setter(StackSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(StackSummary.getter(StackSummary::arn)).setter(StackSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Integer> LAYERS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("LayersCount").getter(StackSummary.getter(StackSummary::layersCount)).setter(StackSummary.setter(Builder::layersCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayersCount").build()}).build();
    private static final SdkField<Integer> APPS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AppsCount").getter(StackSummary.getter(StackSummary::appsCount)).setter(StackSummary.setter(Builder::appsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppsCount").build()}).build();
    private static final SdkField<InstancesCount> INSTANCES_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstancesCount").getter(StackSummary.getter(StackSummary::instancesCount)).setter(StackSummary.setter(Builder::instancesCount)).constructor(InstancesCount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD, NAME_FIELD, ARN_FIELD, LAYERS_COUNT_FIELD, APPS_COUNT_FIELD, INSTANCES_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("StackId", STACK_ID_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Arn", ARN_FIELD);
            this.put("LayersCount", LAYERS_COUNT_FIELD);
            this.put("AppsCount", APPS_COUNT_FIELD);
            this.put("InstancesCount", INSTANCES_COUNT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String stackId;
    private final String name;
    private final String arn;
    private final Integer layersCount;
    private final Integer appsCount;
    private final InstancesCount instancesCount;

    private StackSummary(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.name = builder.name;
        this.arn = builder.arn;
        this.layersCount = builder.layersCount;
        this.appsCount = builder.appsCount;
        this.instancesCount = builder.instancesCount;
    }

    public final String stackId() {
        return this.stackId;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final Integer layersCount() {
        return this.layersCount;
    }

    public final Integer appsCount() {
        return this.appsCount;
    }

    public final InstancesCount instancesCount() {
        return this.instancesCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.layersCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.appsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackSummary)) {
            return false;
        }
        StackSummary other = (StackSummary)obj;
        return Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.layersCount(), other.layersCount()) && Objects.equals(this.appsCount(), other.appsCount()) && Objects.equals(this.instancesCount(), other.instancesCount());
    }

    public final String toString() {
        return ToString.builder((String)"StackSummary").add("StackId", (Object)this.stackId()).add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("LayersCount", (Object)this.layersCount()).add("AppsCount", (Object)this.appsCount()).add("InstancesCount", (Object)this.instancesCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "LayersCount": {
                return Optional.ofNullable(clazz.cast(this.layersCount()));
            }
            case "AppsCount": {
                return Optional.ofNullable(clazz.cast(this.appsCount()));
            }
            case "InstancesCount": {
                return Optional.ofNullable(clazz.cast(this.instancesCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StackSummary, T> g) {
        return obj -> g.apply((StackSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stackId;
        private String name;
        private String arn;
        private Integer layersCount;
        private Integer appsCount;
        private InstancesCount instancesCount;

        private BuilderImpl() {
        }

        private BuilderImpl(StackSummary model) {
            this.stackId(model.stackId);
            this.name(model.name);
            this.arn(model.arn);
            this.layersCount(model.layersCount);
            this.appsCount(model.appsCount);
            this.instancesCount(model.instancesCount);
        }

        public final String getStackId() {
            return this.stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Integer getLayersCount() {
            return this.layersCount;
        }

        public final void setLayersCount(Integer layersCount) {
            this.layersCount = layersCount;
        }

        @Override
        public final Builder layersCount(Integer layersCount) {
            this.layersCount = layersCount;
            return this;
        }

        public final Integer getAppsCount() {
            return this.appsCount;
        }

        public final void setAppsCount(Integer appsCount) {
            this.appsCount = appsCount;
        }

        @Override
        public final Builder appsCount(Integer appsCount) {
            this.appsCount = appsCount;
            return this;
        }

        public final InstancesCount.Builder getInstancesCount() {
            return this.instancesCount != null ? this.instancesCount.toBuilder() : null;
        }

        public final void setInstancesCount(InstancesCount.BuilderImpl instancesCount) {
            this.instancesCount = instancesCount != null ? instancesCount.build() : null;
        }

        @Override
        public final Builder instancesCount(InstancesCount instancesCount) {
            this.instancesCount = instancesCount;
            return this;
        }

        public StackSummary build() {
            return new StackSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StackSummary> {
        public Builder stackId(String var1);

        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder layersCount(Integer var1);

        public Builder appsCount(Integer var1);

        public Builder instancesCount(InstancesCount var1);

        default public Builder instancesCount(Consumer<InstancesCount.Builder> instancesCount) {
            return this.instancesCount((InstancesCount)((InstancesCount.Builder)InstancesCount.builder().applyMutation(instancesCount)).build());
        }
    }
}

