/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeCommands</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCommandsResponse extends OpsWorksResponse implements
        ToCopyableBuilder<DescribeCommandsResponse.Builder, DescribeCommandsResponse> {
    private static final SdkField<List<Command>> COMMANDS_FIELD = SdkField
            .<List<Command>> builder(MarshallingType.LIST)
            .memberName("Commands")
            .getter(getter(DescribeCommandsResponse::commands))
            .setter(setter(Builder::commands))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Commands").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Command> builder(MarshallingType.SDK_POJO)
                                            .constructor(Command::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMANDS_FIELD));

    private final List<Command> commands;

    private DescribeCommandsResponse(BuilderImpl builder) {
        super(builder);
        this.commands = builder.commands;
    }

    /**
     * For responses, this returns true if the service returned a value for the Commands property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCommands() {
        return commands != null && !(commands instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>Command</code> objects that describe each of the specified commands.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCommands} method.
     * </p>
     * 
     * @return An array of <code>Command</code> objects that describe each of the specified commands.
     */
    public final List<Command> commands() {
        return commands;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCommands() ? commands() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCommandsResponse)) {
            return false;
        }
        DescribeCommandsResponse other = (DescribeCommandsResponse) obj;
        return hasCommands() == other.hasCommands() && Objects.equals(commands(), other.commands());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCommandsResponse").add("Commands", hasCommands() ? commands() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Commands":
            return Optional.ofNullable(clazz.cast(commands()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCommandsResponse, T> g) {
        return obj -> g.apply((DescribeCommandsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeCommandsResponse> {
        /**
         * <p>
         * An array of <code>Command</code> objects that describe each of the specified commands.
         * </p>
         * 
         * @param commands
         *        An array of <code>Command</code> objects that describe each of the specified commands.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commands(Collection<Command> commands);

        /**
         * <p>
         * An array of <code>Command</code> objects that describe each of the specified commands.
         * </p>
         * 
         * @param commands
         *        An array of <code>Command</code> objects that describe each of the specified commands.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commands(Command... commands);

        /**
         * <p>
         * An array of <code>Command</code> objects that describe each of the specified commands.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opsworks.model.Command.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.opsworks.model.Command#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opsworks.model.Command.Builder#build()} is called immediately and its
         * result is passed to {@link #commands(List<Command>)}.
         * 
         * @param commands
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opsworks.model.Command.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #commands(java.util.Collection<Command>)
         */
        Builder commands(Consumer<Command.Builder>... commands);
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private List<Command> commands = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCommandsResponse model) {
            super(model);
            commands(model.commands);
        }

        public final List<Command.Builder> getCommands() {
            List<Command.Builder> result = CommandsCopier.copyToBuilder(this.commands);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCommands(Collection<Command.BuilderImpl> commands) {
            this.commands = CommandsCopier.copyFromBuilder(commands);
        }

        @Override
        public final Builder commands(Collection<Command> commands) {
            this.commands = CommandsCopier.copy(commands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commands(Command... commands) {
            commands(Arrays.asList(commands));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commands(Consumer<Command.Builder>... commands) {
            commands(Stream.of(commands).map(c -> Command.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeCommandsResponse build() {
            return new DescribeCommandsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
