/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LayerType {
    AWS_FLOW_RUBY("aws-flow-ruby"),
    ECS_CLUSTER("ecs-cluster"),
    JAVA_APP("java-app"),
    LB("lb"),
    WEB("web"),
    PHP_APP("php-app"),
    RAILS_APP("rails-app"),
    NODEJS_APP("nodejs-app"),
    MEMCACHED("memcached"),
    DB_MASTER("db-master"),
    MONITORING_MASTER("monitoring-master"),
    CUSTOM("custom"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LayerType> VALUE_MAP;
    private final String value;

    private LayerType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LayerType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LayerType> knownValues() {
        EnumSet<LayerType> knownValues = EnumSet.allOf(LayerType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LayerType.class, LayerType::toString);
    }
}

