/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ElasticLoadBalancer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ElasticLoadBalancer> {
    private static final SdkField<String> ELASTIC_LOAD_BALANCER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ElasticLoadBalancerName").getter(ElasticLoadBalancer.getter(ElasticLoadBalancer::elasticLoadBalancerName)).setter(ElasticLoadBalancer.setter(Builder::elasticLoadBalancerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticLoadBalancerName").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(ElasticLoadBalancer.getter(ElasticLoadBalancer::region)).setter(ElasticLoadBalancer.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<String> DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DnsName").getter(ElasticLoadBalancer.getter(ElasticLoadBalancer::dnsName)).setter(ElasticLoadBalancer.setter(Builder::dnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsName").build()}).build();
    private static final SdkField<String> STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackId").getter(ElasticLoadBalancer.getter(ElasticLoadBalancer::stackId)).setter(ElasticLoadBalancer.setter(Builder::stackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()}).build();
    private static final SdkField<String> LAYER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LayerId").getter(ElasticLoadBalancer.getter(ElasticLoadBalancer::layerId)).setter(ElasticLoadBalancer.setter(Builder::layerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayerId").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(ElasticLoadBalancer.getter(ElasticLoadBalancer::vpcId)).setter(ElasticLoadBalancer.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZones").getter(ElasticLoadBalancer.getter(ElasticLoadBalancer::availabilityZones)).setter(ElasticLoadBalancer.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(ElasticLoadBalancer.getter(ElasticLoadBalancer::subnetIds)).setter(ElasticLoadBalancer.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EC2_INSTANCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ec2InstanceIds").getter(ElasticLoadBalancer.getter(ElasticLoadBalancer::ec2InstanceIds)).setter(ElasticLoadBalancer.setter(Builder::ec2InstanceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2InstanceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELASTIC_LOAD_BALANCER_NAME_FIELD, REGION_FIELD, DNS_NAME_FIELD, STACK_ID_FIELD, LAYER_ID_FIELD, VPC_ID_FIELD, AVAILABILITY_ZONES_FIELD, SUBNET_IDS_FIELD, EC2_INSTANCE_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String elasticLoadBalancerName;
    private final String region;
    private final String dnsName;
    private final String stackId;
    private final String layerId;
    private final String vpcId;
    private final List<String> availabilityZones;
    private final List<String> subnetIds;
    private final List<String> ec2InstanceIds;

    private ElasticLoadBalancer(BuilderImpl builder) {
        this.elasticLoadBalancerName = builder.elasticLoadBalancerName;
        this.region = builder.region;
        this.dnsName = builder.dnsName;
        this.stackId = builder.stackId;
        this.layerId = builder.layerId;
        this.vpcId = builder.vpcId;
        this.availabilityZones = builder.availabilityZones;
        this.subnetIds = builder.subnetIds;
        this.ec2InstanceIds = builder.ec2InstanceIds;
    }

    public final String elasticLoadBalancerName() {
        return this.elasticLoadBalancerName;
    }

    public final String region() {
        return this.region;
    }

    public final String dnsName() {
        return this.dnsName;
    }

    public final String stackId() {
        return this.stackId;
    }

    public final String layerId() {
        return this.layerId;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public final List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final boolean hasEc2InstanceIds() {
        return this.ec2InstanceIds != null && !(this.ec2InstanceIds instanceof SdkAutoConstructList);
    }

    public final List<String> ec2InstanceIds() {
        return this.ec2InstanceIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticLoadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.layerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZones() ? this.availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEc2InstanceIds() ? this.ec2InstanceIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticLoadBalancer)) {
            return false;
        }
        ElasticLoadBalancer other = (ElasticLoadBalancer)obj;
        return Objects.equals(this.elasticLoadBalancerName(), other.elasticLoadBalancerName()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.dnsName(), other.dnsName()) && Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.layerId(), other.layerId()) && Objects.equals(this.vpcId(), other.vpcId()) && this.hasAvailabilityZones() == other.hasAvailabilityZones() && Objects.equals(this.availabilityZones(), other.availabilityZones()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && this.hasEc2InstanceIds() == other.hasEc2InstanceIds() && Objects.equals(this.ec2InstanceIds(), other.ec2InstanceIds());
    }

    public final String toString() {
        return ToString.builder((String)"ElasticLoadBalancer").add("ElasticLoadBalancerName", (Object)this.elasticLoadBalancerName()).add("Region", (Object)this.region()).add("DnsName", (Object)this.dnsName()).add("StackId", (Object)this.stackId()).add("LayerId", (Object)this.layerId()).add("VpcId", (Object)this.vpcId()).add("AvailabilityZones", this.hasAvailabilityZones() ? this.availabilityZones() : null).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("Ec2InstanceIds", this.hasEc2InstanceIds() ? this.ec2InstanceIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ElasticLoadBalancerName": {
                return Optional.ofNullable(clazz.cast(this.elasticLoadBalancerName()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "DnsName": {
                return Optional.ofNullable(clazz.cast(this.dnsName()));
            }
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "LayerId": {
                return Optional.ofNullable(clazz.cast(this.layerId()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "Ec2InstanceIds": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ElasticLoadBalancer, T> g) {
        return obj -> g.apply((ElasticLoadBalancer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String elasticLoadBalancerName;
        private String region;
        private String dnsName;
        private String stackId;
        private String layerId;
        private String vpcId;
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> ec2InstanceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticLoadBalancer model) {
            this.elasticLoadBalancerName(model.elasticLoadBalancerName);
            this.region(model.region);
            this.dnsName(model.dnsName);
            this.stackId(model.stackId);
            this.layerId(model.layerId);
            this.vpcId(model.vpcId);
            this.availabilityZones(model.availabilityZones);
            this.subnetIds(model.subnetIds);
            this.ec2InstanceIds(model.ec2InstanceIds);
        }

        public final String getElasticLoadBalancerName() {
            return this.elasticLoadBalancerName;
        }

        @Override
        public final Builder elasticLoadBalancerName(String elasticLoadBalancerName) {
            this.elasticLoadBalancerName = elasticLoadBalancerName;
            return this;
        }

        public final void setElasticLoadBalancerName(String elasticLoadBalancerName) {
            this.elasticLoadBalancerName = elasticLoadBalancerName;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getDnsName() {
            return this.dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getLayerId() {
            return this.layerId;
        }

        @Override
        public final Builder layerId(String layerId) {
            this.layerId = layerId;
            return this;
        }

        public final void setLayerId(String layerId) {
            this.layerId = layerId;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Collection<String> getAvailabilityZones() {
            if (this.availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = StringsCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = StringsCopier.copy(availabilityZones);
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringsCopier.copy(subnetIds);
        }

        public final Collection<String> getEc2InstanceIds() {
            if (this.ec2InstanceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ec2InstanceIds;
        }

        @Override
        public final Builder ec2InstanceIds(Collection<String> ec2InstanceIds) {
            this.ec2InstanceIds = StringsCopier.copy(ec2InstanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InstanceIds(String ... ec2InstanceIds) {
            this.ec2InstanceIds(Arrays.asList(ec2InstanceIds));
            return this;
        }

        public final void setEc2InstanceIds(Collection<String> ec2InstanceIds) {
            this.ec2InstanceIds = StringsCopier.copy(ec2InstanceIds);
        }

        public ElasticLoadBalancer build() {
            return new ElasticLoadBalancer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ElasticLoadBalancer> {
        public Builder elasticLoadBalancerName(String var1);

        public Builder region(String var1);

        public Builder dnsName(String var1);

        public Builder stackId(String var1);

        public Builder layerId(String var1);

        public Builder vpcId(String var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder ec2InstanceIds(Collection<String> var1);

        public Builder ec2InstanceIds(String ... var1);
    }
}

