/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Recipes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Recipes> {
    private static final SdkField<List<String>> SETUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Setup").getter(Recipes.getter(Recipes::setup)).setter(Recipes.setter(Builder::setup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Setup").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CONFIGURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Configure").getter(Recipes.getter(Recipes::configure)).setter(Recipes.setter(Builder::configure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configure").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DEPLOY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Deploy").getter(Recipes.getter(Recipes::deploy)).setter(Recipes.setter(Builder::deploy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Deploy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> UNDEPLOY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Undeploy").getter(Recipes.getter(Recipes::undeploy)).setter(Recipes.setter(Builder::undeploy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Undeploy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SHUTDOWN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Shutdown").getter(Recipes.getter(Recipes::shutdown)).setter(Recipes.setter(Builder::shutdown)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Shutdown").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SETUP_FIELD, CONFIGURE_FIELD, DEPLOY_FIELD, UNDEPLOY_FIELD, SHUTDOWN_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> setup;
    private final List<String> configure;
    private final List<String> deploy;
    private final List<String> undeploy;
    private final List<String> shutdown;

    private Recipes(BuilderImpl builder) {
        this.setup = builder.setup;
        this.configure = builder.configure;
        this.deploy = builder.deploy;
        this.undeploy = builder.undeploy;
        this.shutdown = builder.shutdown;
    }

    public final boolean hasSetup() {
        return this.setup != null && !(this.setup instanceof SdkAutoConstructList);
    }

    public final List<String> setup() {
        return this.setup;
    }

    public final boolean hasConfigure() {
        return this.configure != null && !(this.configure instanceof SdkAutoConstructList);
    }

    public final List<String> configure() {
        return this.configure;
    }

    public final boolean hasDeploy() {
        return this.deploy != null && !(this.deploy instanceof SdkAutoConstructList);
    }

    public final List<String> deploy() {
        return this.deploy;
    }

    public final boolean hasUndeploy() {
        return this.undeploy != null && !(this.undeploy instanceof SdkAutoConstructList);
    }

    public final List<String> undeploy() {
        return this.undeploy;
    }

    public final boolean hasShutdown() {
        return this.shutdown != null && !(this.shutdown instanceof SdkAutoConstructList);
    }

    public final List<String> shutdown() {
        return this.shutdown;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSetup() ? this.setup() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigure() ? this.configure() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeploy() ? this.deploy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUndeploy() ? this.undeploy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasShutdown() ? this.shutdown() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Recipes)) {
            return false;
        }
        Recipes other = (Recipes)obj;
        return this.hasSetup() == other.hasSetup() && Objects.equals(this.setup(), other.setup()) && this.hasConfigure() == other.hasConfigure() && Objects.equals(this.configure(), other.configure()) && this.hasDeploy() == other.hasDeploy() && Objects.equals(this.deploy(), other.deploy()) && this.hasUndeploy() == other.hasUndeploy() && Objects.equals(this.undeploy(), other.undeploy()) && this.hasShutdown() == other.hasShutdown() && Objects.equals(this.shutdown(), other.shutdown());
    }

    public final String toString() {
        return ToString.builder((String)"Recipes").add("Setup", this.hasSetup() ? this.setup() : null).add("Configure", this.hasConfigure() ? this.configure() : null).add("Deploy", this.hasDeploy() ? this.deploy() : null).add("Undeploy", this.hasUndeploy() ? this.undeploy() : null).add("Shutdown", this.hasShutdown() ? this.shutdown() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Setup": {
                return Optional.ofNullable(clazz.cast(this.setup()));
            }
            case "Configure": {
                return Optional.ofNullable(clazz.cast(this.configure()));
            }
            case "Deploy": {
                return Optional.ofNullable(clazz.cast(this.deploy()));
            }
            case "Undeploy": {
                return Optional.ofNullable(clazz.cast(this.undeploy()));
            }
            case "Shutdown": {
                return Optional.ofNullable(clazz.cast(this.shutdown()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Recipes, T> g) {
        return obj -> g.apply((Recipes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> setup = DefaultSdkAutoConstructList.getInstance();
        private List<String> configure = DefaultSdkAutoConstructList.getInstance();
        private List<String> deploy = DefaultSdkAutoConstructList.getInstance();
        private List<String> undeploy = DefaultSdkAutoConstructList.getInstance();
        private List<String> shutdown = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Recipes model) {
            this.setup(model.setup);
            this.configure(model.configure);
            this.deploy(model.deploy);
            this.undeploy(model.undeploy);
            this.shutdown(model.shutdown);
        }

        public final Collection<String> getSetup() {
            if (this.setup instanceof SdkAutoConstructList) {
                return null;
            }
            return this.setup;
        }

        @Override
        public final Builder setup(Collection<String> setup) {
            this.setup = StringsCopier.copy(setup);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder setup(String ... setup) {
            this.setup(Arrays.asList(setup));
            return this;
        }

        public final void setSetup(Collection<String> setup) {
            this.setup = StringsCopier.copy(setup);
        }

        public final Collection<String> getConfigure() {
            if (this.configure instanceof SdkAutoConstructList) {
                return null;
            }
            return this.configure;
        }

        @Override
        public final Builder configure(Collection<String> configure) {
            this.configure = StringsCopier.copy(configure);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configure(String ... configure) {
            this.configure(Arrays.asList(configure));
            return this;
        }

        public final void setConfigure(Collection<String> configure) {
            this.configure = StringsCopier.copy(configure);
        }

        public final Collection<String> getDeploy() {
            if (this.deploy instanceof SdkAutoConstructList) {
                return null;
            }
            return this.deploy;
        }

        @Override
        public final Builder deploy(Collection<String> deploy) {
            this.deploy = StringsCopier.copy(deploy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploy(String ... deploy) {
            this.deploy(Arrays.asList(deploy));
            return this;
        }

        public final void setDeploy(Collection<String> deploy) {
            this.deploy = StringsCopier.copy(deploy);
        }

        public final Collection<String> getUndeploy() {
            if (this.undeploy instanceof SdkAutoConstructList) {
                return null;
            }
            return this.undeploy;
        }

        @Override
        public final Builder undeploy(Collection<String> undeploy) {
            this.undeploy = StringsCopier.copy(undeploy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder undeploy(String ... undeploy) {
            this.undeploy(Arrays.asList(undeploy));
            return this;
        }

        public final void setUndeploy(Collection<String> undeploy) {
            this.undeploy = StringsCopier.copy(undeploy);
        }

        public final Collection<String> getShutdown() {
            if (this.shutdown instanceof SdkAutoConstructList) {
                return null;
            }
            return this.shutdown;
        }

        @Override
        public final Builder shutdown(Collection<String> shutdown) {
            this.shutdown = StringsCopier.copy(shutdown);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shutdown(String ... shutdown) {
            this.shutdown(Arrays.asList(shutdown));
            return this;
        }

        public final void setShutdown(Collection<String> shutdown) {
            this.shutdown = StringsCopier.copy(shutdown);
        }

        public Recipes build() {
            return new Recipes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Recipes> {
        public Builder setup(Collection<String> var1);

        public Builder setup(String ... var1);

        public Builder configure(Collection<String> var1);

        public Builder configure(String ... var1);

        public Builder deploy(Collection<String> var1);

        public Builder deploy(String ... var1);

        public Builder undeploy(Collection<String> var1);

        public Builder undeploy(String ... var1);

        public Builder shutdown(Collection<String> var1);

        public Builder shutdown(String ... var1);
    }
}

