/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.DeploymentCommand;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Deployment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Deployment> {
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentId").getter(Deployment.getter(Deployment::deploymentId)).setter(Deployment.setter(Builder::deploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentId").build()}).build();
    private static final SdkField<String> STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackId").getter(Deployment.getter(Deployment::stackId)).setter(Deployment.setter(Builder::stackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()}).build();
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppId").getter(Deployment.getter(Deployment::appId)).setter(Deployment.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppId").build()}).build();
    private static final SdkField<String> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedAt").getter(Deployment.getter(Deployment::createdAt)).setter(Deployment.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> COMPLETED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompletedAt").getter(Deployment.getter(Deployment::completedAt)).setter(Deployment.setter(Builder::completedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedAt").build()}).build();
    private static final SdkField<Integer> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Duration").getter(Deployment.getter(Deployment::duration)).setter(Deployment.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<String> IAM_USER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamUserArn").getter(Deployment.getter(Deployment::iamUserArn)).setter(Deployment.setter(Builder::iamUserArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamUserArn").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Comment").getter(Deployment.getter(Deployment::comment)).setter(Deployment.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").build()}).build();
    private static final SdkField<DeploymentCommand> COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Command").getter(Deployment.getter(Deployment::command)).setter(Deployment.setter(Builder::command)).constructor(DeploymentCommand::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Command").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Deployment.getter(Deployment::status)).setter(Deployment.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> CUSTOM_JSON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomJson").getter(Deployment.getter(Deployment::customJson)).setter(Deployment.setter(Builder::customJson)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomJson").build()}).build();
    private static final SdkField<List<String>> INSTANCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceIds").getter(Deployment.getter(Deployment::instanceIds)).setter(Deployment.setter(Builder::instanceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_ID_FIELD, STACK_ID_FIELD, APP_ID_FIELD, CREATED_AT_FIELD, COMPLETED_AT_FIELD, DURATION_FIELD, IAM_USER_ARN_FIELD, COMMENT_FIELD, COMMAND_FIELD, STATUS_FIELD, CUSTOM_JSON_FIELD, INSTANCE_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deploymentId;
    private final String stackId;
    private final String appId;
    private final String createdAt;
    private final String completedAt;
    private final Integer duration;
    private final String iamUserArn;
    private final String comment;
    private final DeploymentCommand command;
    private final String status;
    private final String customJson;
    private final List<String> instanceIds;

    private Deployment(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
        this.stackId = builder.stackId;
        this.appId = builder.appId;
        this.createdAt = builder.createdAt;
        this.completedAt = builder.completedAt;
        this.duration = builder.duration;
        this.iamUserArn = builder.iamUserArn;
        this.comment = builder.comment;
        this.command = builder.command;
        this.status = builder.status;
        this.customJson = builder.customJson;
        this.instanceIds = builder.instanceIds;
    }

    public String deploymentId() {
        return this.deploymentId;
    }

    public String stackId() {
        return this.stackId;
    }

    public String appId() {
        return this.appId;
    }

    public String createdAt() {
        return this.createdAt;
    }

    public String completedAt() {
        return this.completedAt;
    }

    public Integer duration() {
        return this.duration;
    }

    public String iamUserArn() {
        return this.iamUserArn;
    }

    public String comment() {
        return this.comment;
    }

    public DeploymentCommand command() {
        return this.command;
    }

    public String status() {
        return this.status;
    }

    public String customJson() {
        return this.customJson;
    }

    public boolean hasInstanceIds() {
        return this.instanceIds != null && !(this.instanceIds instanceof SdkAutoConstructList);
    }

    public List<String> instanceIds() {
        return this.instanceIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.command());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.customJson());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceIds() ? this.instanceIds() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Deployment)) {
            return false;
        }
        Deployment other = (Deployment)obj;
        return Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.appId(), other.appId()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.completedAt(), other.completedAt()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.iamUserArn(), other.iamUserArn()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.command(), other.command()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.customJson(), other.customJson()) && this.hasInstanceIds() == other.hasInstanceIds() && Objects.equals(this.instanceIds(), other.instanceIds());
    }

    public String toString() {
        return ToString.builder((String)"Deployment").add("DeploymentId", (Object)this.deploymentId()).add("StackId", (Object)this.stackId()).add("AppId", (Object)this.appId()).add("CreatedAt", (Object)this.createdAt()).add("CompletedAt", (Object)this.completedAt()).add("Duration", (Object)this.duration()).add("IamUserArn", (Object)this.iamUserArn()).add("Comment", (Object)this.comment()).add("Command", (Object)this.command()).add("Status", (Object)this.status()).add("CustomJson", (Object)this.customJson()).add("InstanceIds", this.hasInstanceIds() ? this.instanceIds() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeploymentId": {
                return Optional.ofNullable(clazz.cast(this.deploymentId()));
            }
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "AppId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "CompletedAt": {
                return Optional.ofNullable(clazz.cast(this.completedAt()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "IamUserArn": {
                return Optional.ofNullable(clazz.cast(this.iamUserArn()));
            }
            case "Comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "Command": {
                return Optional.ofNullable(clazz.cast(this.command()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "CustomJson": {
                return Optional.ofNullable(clazz.cast(this.customJson()));
            }
            case "InstanceIds": {
                return Optional.ofNullable(clazz.cast(this.instanceIds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Deployment, T> g) {
        return obj -> g.apply((Deployment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deploymentId;
        private String stackId;
        private String appId;
        private String createdAt;
        private String completedAt;
        private Integer duration;
        private String iamUserArn;
        private String comment;
        private DeploymentCommand command;
        private String status;
        private String customJson;
        private List<String> instanceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Deployment model) {
            this.deploymentId(model.deploymentId);
            this.stackId(model.stackId);
            this.appId(model.appId);
            this.createdAt(model.createdAt);
            this.completedAt(model.completedAt);
            this.duration(model.duration);
            this.iamUserArn(model.iamUserArn);
            this.comment(model.comment);
            this.command(model.command);
            this.status(model.status);
            this.customJson(model.customJson);
            this.instanceIds(model.instanceIds);
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getAppId() {
            return this.appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final String getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public final String getCompletedAt() {
            return this.completedAt;
        }

        @Override
        public final Builder completedAt(String completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public final void setCompletedAt(String completedAt) {
            this.completedAt = completedAt;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final String getIamUserArn() {
            return this.iamUserArn;
        }

        @Override
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final DeploymentCommand.Builder getCommand() {
            return this.command != null ? this.command.toBuilder() : null;
        }

        @Override
        public final Builder command(DeploymentCommand command) {
            this.command = command;
            return this;
        }

        public final void setCommand(DeploymentCommand.BuilderImpl command) {
            this.command = command != null ? command.build() : null;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getCustomJson() {
            return this.customJson;
        }

        @Override
        public final Builder customJson(String customJson) {
            this.customJson = customJson;
            return this;
        }

        public final void setCustomJson(String customJson) {
            this.customJson = customJson;
        }

        public final Collection<String> getInstanceIds() {
            if (this.instanceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = StringsCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String ... instanceIds) {
            this.instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = StringsCopier.copy(instanceIds);
        }

        public Deployment build() {
            return new Deployment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Deployment> {
        public Builder deploymentId(String var1);

        public Builder stackId(String var1);

        public Builder appId(String var1);

        public Builder createdAt(String var1);

        public Builder completedAt(String var1);

        public Builder duration(Integer var1);

        public Builder iamUserArn(String var1);

        public Builder comment(String var1);

        public Builder command(DeploymentCommand var1);

        default public Builder command(Consumer<DeploymentCommand.Builder> command) {
            return this.command((DeploymentCommand)((DeploymentCommand.Builder)DeploymentCommand.builder().applyMutation(command)).build());
        }

        public Builder status(String var1);

        public Builder customJson(String var1);

        public Builder instanceIds(Collection<String> var1);

        public Builder instanceIds(String ... var1);
    }
}

