/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceIdentity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceIdentity> {
    private static final SdkField<String> DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Document").getter(InstanceIdentity.getter(InstanceIdentity::document)).setter(InstanceIdentity.setter(Builder::document)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Document").build()}).build();
    private static final SdkField<String> SIGNATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Signature").getter(InstanceIdentity.getter(InstanceIdentity::signature)).setter(InstanceIdentity.setter(Builder::signature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Signature").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_FIELD, SIGNATURE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String document;
    private final String signature;

    private InstanceIdentity(BuilderImpl builder) {
        this.document = builder.document;
        this.signature = builder.signature;
    }

    public String document() {
        return this.document;
    }

    public String signature() {
        return this.signature;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.document());
        hashCode = 31 * hashCode + Objects.hashCode(this.signature());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceIdentity)) {
            return false;
        }
        InstanceIdentity other = (InstanceIdentity)obj;
        return Objects.equals(this.document(), other.document()) && Objects.equals(this.signature(), other.signature());
    }

    public String toString() {
        return ToString.builder((String)"InstanceIdentity").add("Document", (Object)this.document()).add("Signature", (Object)this.signature()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Document": {
                return Optional.ofNullable(clazz.cast(this.document()));
            }
            case "Signature": {
                return Optional.ofNullable(clazz.cast(this.signature()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceIdentity, T> g) {
        return obj -> g.apply((InstanceIdentity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String document;
        private String signature;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceIdentity model) {
            this.document(model.document);
            this.signature(model.signature);
        }

        public final String getDocument() {
            return this.document;
        }

        @Override
        public final Builder document(String document) {
            this.document = document;
            return this;
        }

        public final void setDocument(String document) {
            this.document = document;
        }

        public final String getSignature() {
            return this.signature;
        }

        @Override
        public final Builder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public final void setSignature(String signature) {
            this.signature = signature;
        }

        public InstanceIdentity build() {
            return new InstanceIdentity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceIdentity> {
        public Builder document(String var1);

        public Builder signature(String var1);
    }
}

