/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.ElasticIp;
import software.amazon.awssdk.services.opsworks.model.ElasticIpsCopier;
import software.amazon.awssdk.services.opsworks.model.OpsWorksResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeElasticIpsResponse
extends OpsWorksResponse
implements ToCopyableBuilder<Builder, DescribeElasticIpsResponse> {
    private static final SdkField<List<ElasticIp>> ELASTIC_IPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ElasticIps").getter(DescribeElasticIpsResponse.getter(DescribeElasticIpsResponse::elasticIps)).setter(DescribeElasticIpsResponse.setter(Builder::elasticIps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticIps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ElasticIp::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELASTIC_IPS_FIELD));
    private final List<ElasticIp> elasticIps;

    private DescribeElasticIpsResponse(BuilderImpl builder) {
        super(builder);
        this.elasticIps = builder.elasticIps;
    }

    public boolean hasElasticIps() {
        return this.elasticIps != null && !(this.elasticIps instanceof SdkAutoConstructList);
    }

    public List<ElasticIp> elasticIps() {
        return this.elasticIps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasElasticIps() ? this.elasticIps() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticIpsResponse)) {
            return false;
        }
        DescribeElasticIpsResponse other = (DescribeElasticIpsResponse)((Object)obj);
        return this.hasElasticIps() == other.hasElasticIps() && Objects.equals(this.elasticIps(), other.elasticIps());
    }

    public String toString() {
        return ToString.builder((String)"DescribeElasticIpsResponse").add("ElasticIps", this.hasElasticIps() ? this.elasticIps() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ElasticIps": {
                return Optional.ofNullable(clazz.cast(this.elasticIps()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeElasticIpsResponse, T> g) {
        return obj -> g.apply((DescribeElasticIpsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksResponse.BuilderImpl
    implements Builder {
        private List<ElasticIp> elasticIps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticIpsResponse model) {
            super(model);
            this.elasticIps(model.elasticIps);
        }

        public final Collection<ElasticIp.Builder> getElasticIps() {
            if (this.elasticIps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.elasticIps != null ? (Collection)this.elasticIps.stream().map(ElasticIp::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder elasticIps(Collection<ElasticIp> elasticIps) {
            this.elasticIps = ElasticIpsCopier.copy(elasticIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticIps(ElasticIp ... elasticIps) {
            this.elasticIps(Arrays.asList(elasticIps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticIps(Consumer<ElasticIp.Builder> ... elasticIps) {
            this.elasticIps(Stream.of(elasticIps).map(c -> (ElasticIp)((ElasticIp.Builder)ElasticIp.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setElasticIps(Collection<ElasticIp.BuilderImpl> elasticIps) {
            this.elasticIps = ElasticIpsCopier.copyFromBuilder(elasticIps);
        }

        @Override
        public DescribeElasticIpsResponse build() {
            return new DescribeElasticIpsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpsWorksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeElasticIpsResponse> {
        public Builder elasticIps(Collection<ElasticIp> var1);

        public Builder elasticIps(ElasticIp ... var1);

        public Builder elasticIps(Consumer<ElasticIp.Builder> ... var1);
    }
}

