/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.OpsWorksResponse;
import software.amazon.awssdk.services.opsworks.model.RdsDbInstance;
import software.amazon.awssdk.services.opsworks.model.RdsDbInstancesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRdsDbInstancesResponse
extends OpsWorksResponse
implements ToCopyableBuilder<Builder, DescribeRdsDbInstancesResponse> {
    private static final SdkField<List<RdsDbInstance>> RDS_DB_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RdsDbInstances").getter(DescribeRdsDbInstancesResponse.getter(DescribeRdsDbInstancesResponse::rdsDbInstances)).setter(DescribeRdsDbInstancesResponse.setter(Builder::rdsDbInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RdsDbInstances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RdsDbInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RDS_DB_INSTANCES_FIELD));
    private final List<RdsDbInstance> rdsDbInstances;

    private DescribeRdsDbInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.rdsDbInstances = builder.rdsDbInstances;
    }

    public boolean hasRdsDbInstances() {
        return this.rdsDbInstances != null && !(this.rdsDbInstances instanceof SdkAutoConstructList);
    }

    public List<RdsDbInstance> rdsDbInstances() {
        return this.rdsDbInstances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRdsDbInstances() ? this.rdsDbInstances() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRdsDbInstancesResponse)) {
            return false;
        }
        DescribeRdsDbInstancesResponse other = (DescribeRdsDbInstancesResponse)((Object)obj);
        return this.hasRdsDbInstances() == other.hasRdsDbInstances() && Objects.equals(this.rdsDbInstances(), other.rdsDbInstances());
    }

    public String toString() {
        return ToString.builder((String)"DescribeRdsDbInstancesResponse").add("RdsDbInstances", this.hasRdsDbInstances() ? this.rdsDbInstances() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RdsDbInstances": {
                return Optional.ofNullable(clazz.cast(this.rdsDbInstances()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRdsDbInstancesResponse, T> g) {
        return obj -> g.apply((DescribeRdsDbInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksResponse.BuilderImpl
    implements Builder {
        private List<RdsDbInstance> rdsDbInstances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRdsDbInstancesResponse model) {
            super(model);
            this.rdsDbInstances(model.rdsDbInstances);
        }

        public final Collection<RdsDbInstance.Builder> getRdsDbInstances() {
            if (this.rdsDbInstances instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rdsDbInstances != null ? (Collection)this.rdsDbInstances.stream().map(RdsDbInstance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rdsDbInstances(Collection<RdsDbInstance> rdsDbInstances) {
            this.rdsDbInstances = RdsDbInstancesCopier.copy(rdsDbInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rdsDbInstances(RdsDbInstance ... rdsDbInstances) {
            this.rdsDbInstances(Arrays.asList(rdsDbInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rdsDbInstances(Consumer<RdsDbInstance.Builder> ... rdsDbInstances) {
            this.rdsDbInstances(Stream.of(rdsDbInstances).map(c -> (RdsDbInstance)((RdsDbInstance.Builder)RdsDbInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRdsDbInstances(Collection<RdsDbInstance.BuilderImpl> rdsDbInstances) {
            this.rdsDbInstances = RdsDbInstancesCopier.copyFromBuilder(rdsDbInstances);
        }

        @Override
        public DescribeRdsDbInstancesResponse build() {
            return new DescribeRdsDbInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpsWorksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRdsDbInstancesResponse> {
        public Builder rdsDbInstances(Collection<RdsDbInstance> var1);

        public Builder rdsDbInstances(RdsDbInstance ... var1);

        public Builder rdsDbInstances(Consumer<RdsDbInstance.Builder> ... var1);
    }
}

