/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.OpsWorksResponse;
import software.amazon.awssdk.services.opsworks.model.RaidArray;
import software.amazon.awssdk.services.opsworks.model.RaidArraysCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRaidArraysResponse
extends OpsWorksResponse
implements ToCopyableBuilder<Builder, DescribeRaidArraysResponse> {
    private static final SdkField<List<RaidArray>> RAID_ARRAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RaidArrays").getter(DescribeRaidArraysResponse.getter(DescribeRaidArraysResponse::raidArrays)).setter(DescribeRaidArraysResponse.setter(Builder::raidArrays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RaidArrays").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RaidArray::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RAID_ARRAYS_FIELD));
    private final List<RaidArray> raidArrays;

    private DescribeRaidArraysResponse(BuilderImpl builder) {
        super(builder);
        this.raidArrays = builder.raidArrays;
    }

    public boolean hasRaidArrays() {
        return this.raidArrays != null && !(this.raidArrays instanceof SdkAutoConstructList);
    }

    public List<RaidArray> raidArrays() {
        return this.raidArrays;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRaidArrays() ? this.raidArrays() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRaidArraysResponse)) {
            return false;
        }
        DescribeRaidArraysResponse other = (DescribeRaidArraysResponse)((Object)obj);
        return this.hasRaidArrays() == other.hasRaidArrays() && Objects.equals(this.raidArrays(), other.raidArrays());
    }

    public String toString() {
        return ToString.builder((String)"DescribeRaidArraysResponse").add("RaidArrays", this.hasRaidArrays() ? this.raidArrays() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RaidArrays": {
                return Optional.ofNullable(clazz.cast(this.raidArrays()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRaidArraysResponse, T> g) {
        return obj -> g.apply((DescribeRaidArraysResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksResponse.BuilderImpl
    implements Builder {
        private List<RaidArray> raidArrays = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRaidArraysResponse model) {
            super(model);
            this.raidArrays(model.raidArrays);
        }

        public final Collection<RaidArray.Builder> getRaidArrays() {
            if (this.raidArrays instanceof SdkAutoConstructList) {
                return null;
            }
            return this.raidArrays != null ? (Collection)this.raidArrays.stream().map(RaidArray::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder raidArrays(Collection<RaidArray> raidArrays) {
            this.raidArrays = RaidArraysCopier.copy(raidArrays);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder raidArrays(RaidArray ... raidArrays) {
            this.raidArrays(Arrays.asList(raidArrays));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder raidArrays(Consumer<RaidArray.Builder> ... raidArrays) {
            this.raidArrays(Stream.of(raidArrays).map(c -> (RaidArray)((RaidArray.Builder)RaidArray.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRaidArrays(Collection<RaidArray.BuilderImpl> raidArrays) {
            this.raidArrays = RaidArraysCopier.copyFromBuilder(raidArrays);
        }

        @Override
        public DescribeRaidArraysResponse build() {
            return new DescribeRaidArraysResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpsWorksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRaidArraysResponse> {
        public Builder raidArrays(Collection<RaidArray> var1);

        public Builder raidArrays(RaidArray ... var1);

        public Builder raidArrays(Consumer<RaidArray.Builder> ... var1);
    }
}

