/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.Layer;
import software.amazon.awssdk.services.opsworks.model.LayersCopier;
import software.amazon.awssdk.services.opsworks.model.OpsWorksResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLayersResponse
extends OpsWorksResponse
implements ToCopyableBuilder<Builder, DescribeLayersResponse> {
    private static final SdkField<List<Layer>> LAYERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Layers").getter(DescribeLayersResponse.getter(DescribeLayersResponse::layers)).setter(DescribeLayersResponse.setter(Builder::layers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Layers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Layer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYERS_FIELD));
    private final List<Layer> layers;

    private DescribeLayersResponse(BuilderImpl builder) {
        super(builder);
        this.layers = builder.layers;
    }

    public boolean hasLayers() {
        return this.layers != null && !(this.layers instanceof SdkAutoConstructList);
    }

    public List<Layer> layers() {
        return this.layers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.layers());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLayersResponse)) {
            return false;
        }
        DescribeLayersResponse other = (DescribeLayersResponse)((Object)obj);
        return Objects.equals(this.layers(), other.layers());
    }

    public String toString() {
        return ToString.builder((String)"DescribeLayersResponse").add("Layers", this.layers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Layers": {
                return Optional.ofNullable(clazz.cast(this.layers()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLayersResponse, T> g) {
        return obj -> g.apply((DescribeLayersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksResponse.BuilderImpl
    implements Builder {
        private List<Layer> layers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLayersResponse model) {
            super(model);
            this.layers(model.layers);
        }

        public final Collection<Layer.Builder> getLayers() {
            return this.layers != null ? (Collection)this.layers.stream().map(Layer::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder layers(Collection<Layer> layers) {
            this.layers = LayersCopier.copy(layers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(Layer ... layers) {
            this.layers(Arrays.asList(layers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(Consumer<Layer.Builder> ... layers) {
            this.layers(Stream.of(layers).map(c -> (Layer)((Layer.Builder)Layer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLayers(Collection<Layer.BuilderImpl> layers) {
            this.layers = LayersCopier.copyFromBuilder(layers);
        }

        @Override
        public DescribeLayersResponse build() {
            return new DescribeLayersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpsWorksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLayersResponse> {
        public Builder layers(Collection<Layer> var1);

        public Builder layers(Layer ... var1);

        public Builder layers(Consumer<Layer.Builder> ... var1);
    }
}

