/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum VirtualizationType {
    PARAVIRTUAL("paravirtual"),
    HVM("hvm"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private VirtualizationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VirtualizationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(VirtualizationType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VirtualizationType> knownValues() {
        return Stream.of(VirtualizationType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

