/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.SelfUserProfile;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SelfUserProfileMarshaller {
    private static final MarshallingInfo<String> IAMUSERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IamUserArn").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> SSHUSERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SshUsername").isBinary(false).build();
    private static final MarshallingInfo<String> SSHPUBLICKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SshPublicKey").isBinary(false).build();
    private static final SelfUserProfileMarshaller INSTANCE = new SelfUserProfileMarshaller();

    private SelfUserProfileMarshaller() {
    }

    public static SelfUserProfileMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SelfUserProfile selfUserProfile, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)selfUserProfile, (String)"selfUserProfile");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)selfUserProfile.iamUserArn(), IAMUSERARN_BINDING);
            protocolMarshaller.marshall((Object)selfUserProfile.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)selfUserProfile.sshUsername(), SSHUSERNAME_BINDING);
            protocolMarshaller.marshall((Object)selfUserProfile.sshPublicKey(), SSHPUBLICKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

