/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.Recipes;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RecipesMarshaller {
    private static final MarshallingInfo<List> SETUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Setup").isBinary(false).build();
    private static final MarshallingInfo<List> CONFIGURE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Configure").isBinary(false).build();
    private static final MarshallingInfo<List> DEPLOY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Deploy").isBinary(false).build();
    private static final MarshallingInfo<List> UNDEPLOY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Undeploy").isBinary(false).build();
    private static final MarshallingInfo<List> SHUTDOWN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Shutdown").isBinary(false).build();
    private static final RecipesMarshaller INSTANCE = new RecipesMarshaller();

    private RecipesMarshaller() {
    }

    public static RecipesMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Recipes recipes, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)recipes, (String)"recipes");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(recipes.setup(), SETUP_BINDING);
            protocolMarshaller.marshall(recipes.configure(), CONFIGURE_BINDING);
            protocolMarshaller.marshall(recipes.deploy(), DEPLOY_BINDING);
            protocolMarshaller.marshall(recipes.undeploy(), UNDEPLOY_BINDING);
            protocolMarshaller.marshall(recipes.shutdown(), SHUTDOWN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

