/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.CreateStackRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateStackRequestModelMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Region").isBinary(false).build();
    private static final MarshallingInfo<String> VPCID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcId").isBinary(false).build();
    private static final MarshallingInfo<Map> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attributes").isBinary(false).build();
    private static final MarshallingInfo<String> SERVICEROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceRoleArn").isBinary(false).build();
    private static final MarshallingInfo<String> DEFAULTINSTANCEPROFILEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultInstanceProfileArn").isBinary(false).build();
    private static final MarshallingInfo<String> DEFAULTOS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultOs").isBinary(false).build();
    private static final MarshallingInfo<String> HOSTNAMETHEME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HostnameTheme").isBinary(false).build();
    private static final MarshallingInfo<String> DEFAULTAVAILABILITYZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultAvailabilityZone").isBinary(false).build();
    private static final MarshallingInfo<String> DEFAULTSUBNETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultSubnetId").isBinary(false).build();
    private static final MarshallingInfo<String> CUSTOMJSON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CustomJson").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CONFIGURATIONMANAGER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConfigurationManager").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CHEFCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChefConfiguration").isBinary(false).build();
    private static final MarshallingInfo<Boolean> USECUSTOMCOOKBOOKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UseCustomCookbooks").isBinary(false).build();
    private static final MarshallingInfo<Boolean> USEOPSWORKSSECURITYGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UseOpsworksSecurityGroups").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CUSTOMCOOKBOOKSSOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CustomCookbooksSource").isBinary(false).build();
    private static final MarshallingInfo<String> DEFAULTSSHKEYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultSshKeyName").isBinary(false).build();
    private static final MarshallingInfo<String> DEFAULTROOTDEVICETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultRootDeviceType").isBinary(false).build();
    private static final MarshallingInfo<String> AGENTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AgentVersion").isBinary(false).build();
    private static final CreateStackRequestModelMarshaller INSTANCE = new CreateStackRequestModelMarshaller();

    private CreateStackRequestModelMarshaller() {
    }

    public static CreateStackRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateStackRequest createStackRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createStackRequest), (String)"createStackRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createStackRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)createStackRequest.region(), REGION_BINDING);
            protocolMarshaller.marshall((Object)createStackRequest.vpcId(), VPCID_BINDING);
            protocolMarshaller.marshall(createStackRequest.attributesStrings(), ATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)createStackRequest.serviceRoleArn(), SERVICEROLEARN_BINDING);
            protocolMarshaller.marshall((Object)createStackRequest.defaultInstanceProfileArn(), DEFAULTINSTANCEPROFILEARN_BINDING);
            protocolMarshaller.marshall((Object)createStackRequest.defaultOs(), DEFAULTOS_BINDING);
            protocolMarshaller.marshall((Object)createStackRequest.hostnameTheme(), HOSTNAMETHEME_BINDING);
            protocolMarshaller.marshall((Object)createStackRequest.defaultAvailabilityZone(), DEFAULTAVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall((Object)createStackRequest.defaultSubnetId(), DEFAULTSUBNETID_BINDING);
            protocolMarshaller.marshall((Object)createStackRequest.customJson(), CUSTOMJSON_BINDING);
            protocolMarshaller.marshall((Object)createStackRequest.configurationManager(), CONFIGURATIONMANAGER_BINDING);
            protocolMarshaller.marshall((Object)createStackRequest.chefConfiguration(), CHEFCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)createStackRequest.useCustomCookbooks(), USECUSTOMCOOKBOOKS_BINDING);
            protocolMarshaller.marshall((Object)createStackRequest.useOpsworksSecurityGroups(), USEOPSWORKSSECURITYGROUPS_BINDING);
            protocolMarshaller.marshall((Object)createStackRequest.customCookbooksSource(), CUSTOMCOOKBOOKSSOURCE_BINDING);
            protocolMarshaller.marshall((Object)createStackRequest.defaultSshKeyName(), DEFAULTSSHKEYNAME_BINDING);
            protocolMarshaller.marshall((Object)createStackRequest.defaultRootDeviceTypeString(), DEFAULTROOTDEVICETYPE_BINDING);
            protocolMarshaller.marshall((Object)createStackRequest.agentVersion(), AGENTVERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

