/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.CreateDeploymentRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateDeploymentRequestModelMarshaller {
    private static final MarshallingInfo<String> STACKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StackId").isBinary(false).build();
    private static final MarshallingInfo<String> APPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AppId").isBinary(false).build();
    private static final MarshallingInfo<List> INSTANCEIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceIds").isBinary(false).build();
    private static final MarshallingInfo<List> LAYERIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LayerIds").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> COMMAND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Command").isBinary(false).build();
    private static final MarshallingInfo<String> COMMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Comment").isBinary(false).build();
    private static final MarshallingInfo<String> CUSTOMJSON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CustomJson").isBinary(false).build();
    private static final CreateDeploymentRequestModelMarshaller INSTANCE = new CreateDeploymentRequestModelMarshaller();

    private CreateDeploymentRequestModelMarshaller() {
    }

    public static CreateDeploymentRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateDeploymentRequest createDeploymentRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createDeploymentRequest), (String)"createDeploymentRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createDeploymentRequest.stackId(), STACKID_BINDING);
            protocolMarshaller.marshall((Object)createDeploymentRequest.appId(), APPID_BINDING);
            protocolMarshaller.marshall(createDeploymentRequest.instanceIds(), INSTANCEIDS_BINDING);
            protocolMarshaller.marshall(createDeploymentRequest.layerIds(), LAYERIDS_BINDING);
            protocolMarshaller.marshall((Object)createDeploymentRequest.command(), COMMAND_BINDING);
            protocolMarshaller.marshall((Object)createDeploymentRequest.comment(), COMMENT_BINDING);
            protocolMarshaller.marshall((Object)createDeploymentRequest.customJson(), CUSTOMJSON_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

