/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.CreateAppRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateAppRequestModelMarshaller {
    private static final MarshallingInfo<String> STACKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StackId").isBinary(false).build();
    private static final MarshallingInfo<String> SHORTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Shortname").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<List> DATASOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSources").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> APPSOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AppSource").isBinary(false).build();
    private static final MarshallingInfo<List> DOMAINS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Domains").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ENABLESSL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EnableSsl").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SSLCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SslConfiguration").isBinary(false).build();
    private static final MarshallingInfo<Map> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attributes").isBinary(false).build();
    private static final MarshallingInfo<List> ENVIRONMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Environment").isBinary(false).build();
    private static final CreateAppRequestModelMarshaller INSTANCE = new CreateAppRequestModelMarshaller();

    private CreateAppRequestModelMarshaller() {
    }

    public static CreateAppRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateAppRequest createAppRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createAppRequest), (String)"createAppRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createAppRequest.stackId(), STACKID_BINDING);
            protocolMarshaller.marshall((Object)createAppRequest.shortname(), SHORTNAME_BINDING);
            protocolMarshaller.marshall((Object)createAppRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)createAppRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(createAppRequest.dataSources(), DATASOURCES_BINDING);
            protocolMarshaller.marshall((Object)createAppRequest.typeString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)createAppRequest.appSource(), APPSOURCE_BINDING);
            protocolMarshaller.marshall(createAppRequest.domains(), DOMAINS_BINDING);
            protocolMarshaller.marshall((Object)createAppRequest.enableSsl(), ENABLESSL_BINDING);
            protocolMarshaller.marshall((Object)createAppRequest.sslConfiguration(), SSLCONFIGURATION_BINDING);
            protocolMarshaller.marshall(createAppRequest.attributesStrings(), ATTRIBUTES_BINDING);
            protocolMarshaller.marshall(createAppRequest.environment(), ENVIRONMENT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

