/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.SourceType;
import software.amazon.awssdk.services.opsworks.transform.SourceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Source
implements StructuredPojo,
ToCopyableBuilder<Builder, Source> {
    private final String type;
    private final String url;
    private final String username;
    private final String password;
    private final String sshKey;
    private final String revision;

    private Source(BuilderImpl builder) {
        this.type = builder.type;
        this.url = builder.url;
        this.username = builder.username;
        this.password = builder.password;
        this.sshKey = builder.sshKey;
        this.revision = builder.revision;
    }

    public SourceType type() {
        return SourceType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public String url() {
        return this.url;
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public String sshKey() {
        return this.sshKey;
    }

    public String revision() {
        return this.revision;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Source)) {
            return false;
        }
        Source other = (Source)obj;
        return Objects.equals(this.typeString(), other.typeString()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.password(), other.password()) && Objects.equals(this.sshKey(), other.sshKey()) && Objects.equals(this.revision(), other.revision());
    }

    public String toString() {
        return ToString.builder((String)"Source").add("Type", (Object)this.typeString()).add("Url", (Object)this.url()).add("Username", (Object)this.username()).add("Password", (Object)this.password()).add("SshKey", (Object)this.sshKey()).add("Revision", (Object)this.revision()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "Url": {
                return Optional.of(clazz.cast(this.url()));
            }
            case "Username": {
                return Optional.of(clazz.cast(this.username()));
            }
            case "Password": {
                return Optional.of(clazz.cast(this.password()));
            }
            case "SshKey": {
                return Optional.of(clazz.cast(this.sshKey()));
            }
            case "Revision": {
                return Optional.of(clazz.cast(this.revision()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String url;
        private String username;
        private String password;
        private String sshKey;
        private String revision;

        private BuilderImpl() {
        }

        private BuilderImpl(Source model) {
            this.type(model.type);
            this.url(model.url);
            this.username(model.username);
            this.password(model.password);
            this.sshKey(model.sshKey);
            this.revision(model.revision);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SourceType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getPassword() {
            return this.password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final String getSshKey() {
            return this.sshKey;
        }

        @Override
        public final Builder sshKey(String sshKey) {
            this.sshKey = sshKey;
            return this;
        }

        public final void setSshKey(String sshKey) {
            this.sshKey = sshKey;
        }

        public final String getRevision() {
            return this.revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        public Source build() {
            return new Source(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Source> {
        public Builder type(String var1);

        public Builder type(SourceType var1);

        public Builder url(String var1);

        public Builder username(String var1);

        public Builder password(String var1);

        public Builder sshKey(String var1);

        public Builder revision(String var1);
    }
}

