/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.Architecture;
import software.amazon.awssdk.services.opsworks.model.AutoScalingType;
import software.amazon.awssdk.services.opsworks.model.BlockDeviceMapping;
import software.amazon.awssdk.services.opsworks.model.BlockDeviceMappingsCopier;
import software.amazon.awssdk.services.opsworks.model.ReportedOs;
import software.amazon.awssdk.services.opsworks.model.RootDeviceType;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.services.opsworks.model.VirtualizationType;
import software.amazon.awssdk.services.opsworks.transform.InstanceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Instance
implements StructuredPojo,
ToCopyableBuilder<Builder, Instance> {
    private final String agentVersion;
    private final String amiId;
    private final String architecture;
    private final String arn;
    private final String autoScalingType;
    private final String availabilityZone;
    private final List<BlockDeviceMapping> blockDeviceMappings;
    private final String createdAt;
    private final Boolean ebsOptimized;
    private final String ec2InstanceId;
    private final String ecsClusterArn;
    private final String ecsContainerInstanceArn;
    private final String elasticIp;
    private final String hostname;
    private final String infrastructureClass;
    private final Boolean installUpdatesOnBoot;
    private final String instanceId;
    private final String instanceProfileArn;
    private final String instanceType;
    private final String lastServiceErrorId;
    private final List<String> layerIds;
    private final String os;
    private final String platform;
    private final String privateDns;
    private final String privateIp;
    private final String publicDns;
    private final String publicIp;
    private final String registeredBy;
    private final String reportedAgentVersion;
    private final ReportedOs reportedOs;
    private final String rootDeviceType;
    private final String rootDeviceVolumeId;
    private final List<String> securityGroupIds;
    private final String sshHostDsaKeyFingerprint;
    private final String sshHostRsaKeyFingerprint;
    private final String sshKeyName;
    private final String stackId;
    private final String status;
    private final String subnetId;
    private final String tenancy;
    private final String virtualizationType;

    private Instance(BuilderImpl builder) {
        this.agentVersion = builder.agentVersion;
        this.amiId = builder.amiId;
        this.architecture = builder.architecture;
        this.arn = builder.arn;
        this.autoScalingType = builder.autoScalingType;
        this.availabilityZone = builder.availabilityZone;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.createdAt = builder.createdAt;
        this.ebsOptimized = builder.ebsOptimized;
        this.ec2InstanceId = builder.ec2InstanceId;
        this.ecsClusterArn = builder.ecsClusterArn;
        this.ecsContainerInstanceArn = builder.ecsContainerInstanceArn;
        this.elasticIp = builder.elasticIp;
        this.hostname = builder.hostname;
        this.infrastructureClass = builder.infrastructureClass;
        this.installUpdatesOnBoot = builder.installUpdatesOnBoot;
        this.instanceId = builder.instanceId;
        this.instanceProfileArn = builder.instanceProfileArn;
        this.instanceType = builder.instanceType;
        this.lastServiceErrorId = builder.lastServiceErrorId;
        this.layerIds = builder.layerIds;
        this.os = builder.os;
        this.platform = builder.platform;
        this.privateDns = builder.privateDns;
        this.privateIp = builder.privateIp;
        this.publicDns = builder.publicDns;
        this.publicIp = builder.publicIp;
        this.registeredBy = builder.registeredBy;
        this.reportedAgentVersion = builder.reportedAgentVersion;
        this.reportedOs = builder.reportedOs;
        this.rootDeviceType = builder.rootDeviceType;
        this.rootDeviceVolumeId = builder.rootDeviceVolumeId;
        this.securityGroupIds = builder.securityGroupIds;
        this.sshHostDsaKeyFingerprint = builder.sshHostDsaKeyFingerprint;
        this.sshHostRsaKeyFingerprint = builder.sshHostRsaKeyFingerprint;
        this.sshKeyName = builder.sshKeyName;
        this.stackId = builder.stackId;
        this.status = builder.status;
        this.subnetId = builder.subnetId;
        this.tenancy = builder.tenancy;
        this.virtualizationType = builder.virtualizationType;
    }

    public String agentVersion() {
        return this.agentVersion;
    }

    public String amiId() {
        return this.amiId;
    }

    public Architecture architecture() {
        return Architecture.fromValue(this.architecture);
    }

    public String architectureString() {
        return this.architecture;
    }

    public String arn() {
        return this.arn;
    }

    public AutoScalingType autoScalingType() {
        return AutoScalingType.fromValue(this.autoScalingType);
    }

    public String autoScalingTypeString() {
        return this.autoScalingType;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public List<BlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public String createdAt() {
        return this.createdAt;
    }

    public Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public String ec2InstanceId() {
        return this.ec2InstanceId;
    }

    public String ecsClusterArn() {
        return this.ecsClusterArn;
    }

    public String ecsContainerInstanceArn() {
        return this.ecsContainerInstanceArn;
    }

    public String elasticIp() {
        return this.elasticIp;
    }

    public String hostname() {
        return this.hostname;
    }

    public String infrastructureClass() {
        return this.infrastructureClass;
    }

    public Boolean installUpdatesOnBoot() {
        return this.installUpdatesOnBoot;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String instanceProfileArn() {
        return this.instanceProfileArn;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public String lastServiceErrorId() {
        return this.lastServiceErrorId;
    }

    public List<String> layerIds() {
        return this.layerIds;
    }

    public String os() {
        return this.os;
    }

    public String platform() {
        return this.platform;
    }

    public String privateDns() {
        return this.privateDns;
    }

    public String privateIp() {
        return this.privateIp;
    }

    public String publicDns() {
        return this.publicDns;
    }

    public String publicIp() {
        return this.publicIp;
    }

    public String registeredBy() {
        return this.registeredBy;
    }

    public String reportedAgentVersion() {
        return this.reportedAgentVersion;
    }

    public ReportedOs reportedOs() {
        return this.reportedOs;
    }

    public RootDeviceType rootDeviceType() {
        return RootDeviceType.fromValue(this.rootDeviceType);
    }

    public String rootDeviceTypeString() {
        return this.rootDeviceType;
    }

    public String rootDeviceVolumeId() {
        return this.rootDeviceVolumeId;
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public String sshHostDsaKeyFingerprint() {
        return this.sshHostDsaKeyFingerprint;
    }

    public String sshHostRsaKeyFingerprint() {
        return this.sshHostRsaKeyFingerprint;
    }

    public String sshKeyName() {
        return this.sshKeyName;
    }

    public String stackId() {
        return this.stackId;
    }

    public String status() {
        return this.status;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public String tenancy() {
        return this.tenancy;
    }

    public VirtualizationType virtualizationType() {
        return VirtualizationType.fromValue(this.virtualizationType);
    }

    public String virtualizationTypeString() {
        return this.virtualizationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.amiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.architectureString());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockDeviceMappings());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ecsClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ecsContainerInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.infrastructureClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.installUpdatesOnBoot());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastServiceErrorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.layerIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.os());
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDns());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicDns());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.registeredBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportedAgentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportedOs());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootDeviceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootDeviceVolumeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshHostDsaKeyFingerprint());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshHostRsaKeyFingerprint());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshKeyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenancy());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualizationTypeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance)obj;
        return Objects.equals(this.agentVersion(), other.agentVersion()) && Objects.equals(this.amiId(), other.amiId()) && Objects.equals(this.architectureString(), other.architectureString()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.autoScalingTypeString(), other.autoScalingTypeString()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.blockDeviceMappings(), other.blockDeviceMappings()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.ebsOptimized(), other.ebsOptimized()) && Objects.equals(this.ec2InstanceId(), other.ec2InstanceId()) && Objects.equals(this.ecsClusterArn(), other.ecsClusterArn()) && Objects.equals(this.ecsContainerInstanceArn(), other.ecsContainerInstanceArn()) && Objects.equals(this.elasticIp(), other.elasticIp()) && Objects.equals(this.hostname(), other.hostname()) && Objects.equals(this.infrastructureClass(), other.infrastructureClass()) && Objects.equals(this.installUpdatesOnBoot(), other.installUpdatesOnBoot()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.instanceProfileArn(), other.instanceProfileArn()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.lastServiceErrorId(), other.lastServiceErrorId()) && Objects.equals(this.layerIds(), other.layerIds()) && Objects.equals(this.os(), other.os()) && Objects.equals(this.platform(), other.platform()) && Objects.equals(this.privateDns(), other.privateDns()) && Objects.equals(this.privateIp(), other.privateIp()) && Objects.equals(this.publicDns(), other.publicDns()) && Objects.equals(this.publicIp(), other.publicIp()) && Objects.equals(this.registeredBy(), other.registeredBy()) && Objects.equals(this.reportedAgentVersion(), other.reportedAgentVersion()) && Objects.equals(this.reportedOs(), other.reportedOs()) && Objects.equals(this.rootDeviceTypeString(), other.rootDeviceTypeString()) && Objects.equals(this.rootDeviceVolumeId(), other.rootDeviceVolumeId()) && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.sshHostDsaKeyFingerprint(), other.sshHostDsaKeyFingerprint()) && Objects.equals(this.sshHostRsaKeyFingerprint(), other.sshHostRsaKeyFingerprint()) && Objects.equals(this.sshKeyName(), other.sshKeyName()) && Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.tenancy(), other.tenancy()) && Objects.equals(this.virtualizationTypeString(), other.virtualizationTypeString());
    }

    public String toString() {
        return ToString.builder((String)"Instance").add("AgentVersion", (Object)this.agentVersion()).add("AmiId", (Object)this.amiId()).add("Architecture", (Object)this.architectureString()).add("Arn", (Object)this.arn()).add("AutoScalingType", (Object)this.autoScalingTypeString()).add("AvailabilityZone", (Object)this.availabilityZone()).add("BlockDeviceMappings", this.blockDeviceMappings()).add("CreatedAt", (Object)this.createdAt()).add("EbsOptimized", (Object)this.ebsOptimized()).add("Ec2InstanceId", (Object)this.ec2InstanceId()).add("EcsClusterArn", (Object)this.ecsClusterArn()).add("EcsContainerInstanceArn", (Object)this.ecsContainerInstanceArn()).add("ElasticIp", (Object)this.elasticIp()).add("Hostname", (Object)this.hostname()).add("InfrastructureClass", (Object)this.infrastructureClass()).add("InstallUpdatesOnBoot", (Object)this.installUpdatesOnBoot()).add("InstanceId", (Object)this.instanceId()).add("InstanceProfileArn", (Object)this.instanceProfileArn()).add("InstanceType", (Object)this.instanceType()).add("LastServiceErrorId", (Object)this.lastServiceErrorId()).add("LayerIds", this.layerIds()).add("Os", (Object)this.os()).add("Platform", (Object)this.platform()).add("PrivateDns", (Object)this.privateDns()).add("PrivateIp", (Object)this.privateIp()).add("PublicDns", (Object)this.publicDns()).add("PublicIp", (Object)this.publicIp()).add("RegisteredBy", (Object)this.registeredBy()).add("ReportedAgentVersion", (Object)this.reportedAgentVersion()).add("ReportedOs", (Object)this.reportedOs()).add("RootDeviceType", (Object)this.rootDeviceTypeString()).add("RootDeviceVolumeId", (Object)this.rootDeviceVolumeId()).add("SecurityGroupIds", this.securityGroupIds()).add("SshHostDsaKeyFingerprint", (Object)this.sshHostDsaKeyFingerprint()).add("SshHostRsaKeyFingerprint", (Object)this.sshHostRsaKeyFingerprint()).add("SshKeyName", (Object)this.sshKeyName()).add("StackId", (Object)this.stackId()).add("Status", (Object)this.status()).add("SubnetId", (Object)this.subnetId()).add("Tenancy", (Object)this.tenancy()).add("VirtualizationType", (Object)this.virtualizationTypeString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AgentVersion": {
                return Optional.of(clazz.cast(this.agentVersion()));
            }
            case "AmiId": {
                return Optional.of(clazz.cast(this.amiId()));
            }
            case "Architecture": {
                return Optional.of(clazz.cast(this.architectureString()));
            }
            case "Arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "AutoScalingType": {
                return Optional.of(clazz.cast(this.autoScalingTypeString()));
            }
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "BlockDeviceMappings": {
                return Optional.of(clazz.cast(this.blockDeviceMappings()));
            }
            case "CreatedAt": {
                return Optional.of(clazz.cast(this.createdAt()));
            }
            case "EbsOptimized": {
                return Optional.of(clazz.cast(this.ebsOptimized()));
            }
            case "Ec2InstanceId": {
                return Optional.of(clazz.cast(this.ec2InstanceId()));
            }
            case "EcsClusterArn": {
                return Optional.of(clazz.cast(this.ecsClusterArn()));
            }
            case "EcsContainerInstanceArn": {
                return Optional.of(clazz.cast(this.ecsContainerInstanceArn()));
            }
            case "ElasticIp": {
                return Optional.of(clazz.cast(this.elasticIp()));
            }
            case "Hostname": {
                return Optional.of(clazz.cast(this.hostname()));
            }
            case "InfrastructureClass": {
                return Optional.of(clazz.cast(this.infrastructureClass()));
            }
            case "InstallUpdatesOnBoot": {
                return Optional.of(clazz.cast(this.installUpdatesOnBoot()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "InstanceProfileArn": {
                return Optional.of(clazz.cast(this.instanceProfileArn()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceType()));
            }
            case "LastServiceErrorId": {
                return Optional.of(clazz.cast(this.lastServiceErrorId()));
            }
            case "LayerIds": {
                return Optional.of(clazz.cast(this.layerIds()));
            }
            case "Os": {
                return Optional.of(clazz.cast(this.os()));
            }
            case "Platform": {
                return Optional.of(clazz.cast(this.platform()));
            }
            case "PrivateDns": {
                return Optional.of(clazz.cast(this.privateDns()));
            }
            case "PrivateIp": {
                return Optional.of(clazz.cast(this.privateIp()));
            }
            case "PublicDns": {
                return Optional.of(clazz.cast(this.publicDns()));
            }
            case "PublicIp": {
                return Optional.of(clazz.cast(this.publicIp()));
            }
            case "RegisteredBy": {
                return Optional.of(clazz.cast(this.registeredBy()));
            }
            case "ReportedAgentVersion": {
                return Optional.of(clazz.cast(this.reportedAgentVersion()));
            }
            case "ReportedOs": {
                return Optional.of(clazz.cast(this.reportedOs()));
            }
            case "RootDeviceType": {
                return Optional.of(clazz.cast(this.rootDeviceTypeString()));
            }
            case "RootDeviceVolumeId": {
                return Optional.of(clazz.cast(this.rootDeviceVolumeId()));
            }
            case "SecurityGroupIds": {
                return Optional.of(clazz.cast(this.securityGroupIds()));
            }
            case "SshHostDsaKeyFingerprint": {
                return Optional.of(clazz.cast(this.sshHostDsaKeyFingerprint()));
            }
            case "SshHostRsaKeyFingerprint": {
                return Optional.of(clazz.cast(this.sshHostRsaKeyFingerprint()));
            }
            case "SshKeyName": {
                return Optional.of(clazz.cast(this.sshKeyName()));
            }
            case "StackId": {
                return Optional.of(clazz.cast(this.stackId()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "SubnetId": {
                return Optional.of(clazz.cast(this.subnetId()));
            }
            case "Tenancy": {
                return Optional.of(clazz.cast(this.tenancy()));
            }
            case "VirtualizationType": {
                return Optional.of(clazz.cast(this.virtualizationTypeString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String agentVersion;
        private String amiId;
        private String architecture;
        private String arn;
        private String autoScalingType;
        private String availabilityZone;
        private List<BlockDeviceMapping> blockDeviceMappings;
        private String createdAt;
        private Boolean ebsOptimized;
        private String ec2InstanceId;
        private String ecsClusterArn;
        private String ecsContainerInstanceArn;
        private String elasticIp;
        private String hostname;
        private String infrastructureClass;
        private Boolean installUpdatesOnBoot;
        private String instanceId;
        private String instanceProfileArn;
        private String instanceType;
        private String lastServiceErrorId;
        private List<String> layerIds;
        private String os;
        private String platform;
        private String privateDns;
        private String privateIp;
        private String publicDns;
        private String publicIp;
        private String registeredBy;
        private String reportedAgentVersion;
        private ReportedOs reportedOs;
        private String rootDeviceType;
        private String rootDeviceVolumeId;
        private List<String> securityGroupIds;
        private String sshHostDsaKeyFingerprint;
        private String sshHostRsaKeyFingerprint;
        private String sshKeyName;
        private String stackId;
        private String status;
        private String subnetId;
        private String tenancy;
        private String virtualizationType;

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            this.agentVersion(model.agentVersion);
            this.amiId(model.amiId);
            this.architecture(model.architecture);
            this.arn(model.arn);
            this.autoScalingType(model.autoScalingType);
            this.availabilityZone(model.availabilityZone);
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.createdAt(model.createdAt);
            this.ebsOptimized(model.ebsOptimized);
            this.ec2InstanceId(model.ec2InstanceId);
            this.ecsClusterArn(model.ecsClusterArn);
            this.ecsContainerInstanceArn(model.ecsContainerInstanceArn);
            this.elasticIp(model.elasticIp);
            this.hostname(model.hostname);
            this.infrastructureClass(model.infrastructureClass);
            this.installUpdatesOnBoot(model.installUpdatesOnBoot);
            this.instanceId(model.instanceId);
            this.instanceProfileArn(model.instanceProfileArn);
            this.instanceType(model.instanceType);
            this.lastServiceErrorId(model.lastServiceErrorId);
            this.layerIds(model.layerIds);
            this.os(model.os);
            this.platform(model.platform);
            this.privateDns(model.privateDns);
            this.privateIp(model.privateIp);
            this.publicDns(model.publicDns);
            this.publicIp(model.publicIp);
            this.registeredBy(model.registeredBy);
            this.reportedAgentVersion(model.reportedAgentVersion);
            this.reportedOs(model.reportedOs);
            this.rootDeviceType(model.rootDeviceType);
            this.rootDeviceVolumeId(model.rootDeviceVolumeId);
            this.securityGroupIds(model.securityGroupIds);
            this.sshHostDsaKeyFingerprint(model.sshHostDsaKeyFingerprint);
            this.sshHostRsaKeyFingerprint(model.sshHostRsaKeyFingerprint);
            this.sshKeyName(model.sshKeyName);
            this.stackId(model.stackId);
            this.status(model.status);
            this.subnetId(model.subnetId);
            this.tenancy(model.tenancy);
            this.virtualizationType(model.virtualizationType);
        }

        public final String getAgentVersion() {
            return this.agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        public final String getAmiId() {
            return this.amiId;
        }

        @Override
        public final Builder amiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public final void setAmiId(String amiId) {
            this.amiId = amiId;
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(Architecture architecture) {
            this.architecture(architecture.toString());
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getAutoScalingType() {
            return this.autoScalingType;
        }

        @Override
        public final Builder autoScalingType(String autoScalingType) {
            this.autoScalingType = autoScalingType;
            return this;
        }

        @Override
        public final Builder autoScalingType(AutoScalingType autoScalingType) {
            this.autoScalingType(autoScalingType.toString());
            return this;
        }

        public final void setAutoScalingType(String autoScalingType) {
            this.autoScalingType = autoScalingType;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Collection<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            return this.blockDeviceMappings != null ? (Collection)this.blockDeviceMappings.stream().map(BlockDeviceMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingsCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingsCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final String getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final String getEc2InstanceId() {
            return this.ec2InstanceId;
        }

        @Override
        public final Builder ec2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
            return this;
        }

        public final void setEc2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
        }

        public final String getEcsClusterArn() {
            return this.ecsClusterArn;
        }

        @Override
        public final Builder ecsClusterArn(String ecsClusterArn) {
            this.ecsClusterArn = ecsClusterArn;
            return this;
        }

        public final void setEcsClusterArn(String ecsClusterArn) {
            this.ecsClusterArn = ecsClusterArn;
        }

        public final String getEcsContainerInstanceArn() {
            return this.ecsContainerInstanceArn;
        }

        @Override
        public final Builder ecsContainerInstanceArn(String ecsContainerInstanceArn) {
            this.ecsContainerInstanceArn = ecsContainerInstanceArn;
            return this;
        }

        public final void setEcsContainerInstanceArn(String ecsContainerInstanceArn) {
            this.ecsContainerInstanceArn = ecsContainerInstanceArn;
        }

        public final String getElasticIp() {
            return this.elasticIp;
        }

        @Override
        public final Builder elasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
            return this;
        }

        public final void setElasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
        }

        public final String getHostname() {
            return this.hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public final String getInfrastructureClass() {
            return this.infrastructureClass;
        }

        @Override
        public final Builder infrastructureClass(String infrastructureClass) {
            this.infrastructureClass = infrastructureClass;
            return this;
        }

        public final void setInfrastructureClass(String infrastructureClass) {
            this.infrastructureClass = infrastructureClass;
        }

        public final Boolean getInstallUpdatesOnBoot() {
            return this.installUpdatesOnBoot;
        }

        @Override
        public final Builder installUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
            return this;
        }

        public final void setInstallUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getInstanceProfileArn() {
            return this.instanceProfileArn;
        }

        @Override
        public final Builder instanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
            return this;
        }

        public final void setInstanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getLastServiceErrorId() {
            return this.lastServiceErrorId;
        }

        @Override
        public final Builder lastServiceErrorId(String lastServiceErrorId) {
            this.lastServiceErrorId = lastServiceErrorId;
            return this;
        }

        public final void setLastServiceErrorId(String lastServiceErrorId) {
            this.lastServiceErrorId = lastServiceErrorId;
        }

        public final Collection<String> getLayerIds() {
            return this.layerIds;
        }

        @Override
        public final Builder layerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layerIds(String ... layerIds) {
            this.layerIds(Arrays.asList(layerIds));
            return this;
        }

        public final void setLayerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
        }

        public final String getOs() {
            return this.os;
        }

        @Override
        public final Builder os(String os) {
            this.os = os;
            return this;
        }

        public final void setOs(String os) {
            this.os = os;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getPrivateDns() {
            return this.privateDns;
        }

        @Override
        public final Builder privateDns(String privateDns) {
            this.privateDns = privateDns;
            return this;
        }

        public final void setPrivateDns(String privateDns) {
            this.privateDns = privateDns;
        }

        public final String getPrivateIp() {
            return this.privateIp;
        }

        @Override
        public final Builder privateIp(String privateIp) {
            this.privateIp = privateIp;
            return this;
        }

        public final void setPrivateIp(String privateIp) {
            this.privateIp = privateIp;
        }

        public final String getPublicDns() {
            return this.publicDns;
        }

        @Override
        public final Builder publicDns(String publicDns) {
            this.publicDns = publicDns;
            return this;
        }

        public final void setPublicDns(String publicDns) {
            this.publicDns = publicDns;
        }

        public final String getPublicIp() {
            return this.publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public final String getRegisteredBy() {
            return this.registeredBy;
        }

        @Override
        public final Builder registeredBy(String registeredBy) {
            this.registeredBy = registeredBy;
            return this;
        }

        public final void setRegisteredBy(String registeredBy) {
            this.registeredBy = registeredBy;
        }

        public final String getReportedAgentVersion() {
            return this.reportedAgentVersion;
        }

        @Override
        public final Builder reportedAgentVersion(String reportedAgentVersion) {
            this.reportedAgentVersion = reportedAgentVersion;
            return this;
        }

        public final void setReportedAgentVersion(String reportedAgentVersion) {
            this.reportedAgentVersion = reportedAgentVersion;
        }

        public final ReportedOs.Builder getReportedOs() {
            return this.reportedOs != null ? this.reportedOs.toBuilder() : null;
        }

        @Override
        public final Builder reportedOs(ReportedOs reportedOs) {
            this.reportedOs = reportedOs;
            return this;
        }

        public final void setReportedOs(ReportedOs.BuilderImpl reportedOs) {
            this.reportedOs = reportedOs != null ? reportedOs.build() : null;
        }

        public final String getRootDeviceType() {
            return this.rootDeviceType;
        }

        @Override
        public final Builder rootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
            return this;
        }

        @Override
        public final Builder rootDeviceType(RootDeviceType rootDeviceType) {
            this.rootDeviceType(rootDeviceType.toString());
            return this;
        }

        public final void setRootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
        }

        public final String getRootDeviceVolumeId() {
            return this.rootDeviceVolumeId;
        }

        @Override
        public final Builder rootDeviceVolumeId(String rootDeviceVolumeId) {
            this.rootDeviceVolumeId = rootDeviceVolumeId;
            return this;
        }

        public final void setRootDeviceVolumeId(String rootDeviceVolumeId) {
            this.rootDeviceVolumeId = rootDeviceVolumeId;
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringsCopier.copy(securityGroupIds);
        }

        public final String getSshHostDsaKeyFingerprint() {
            return this.sshHostDsaKeyFingerprint;
        }

        @Override
        public final Builder sshHostDsaKeyFingerprint(String sshHostDsaKeyFingerprint) {
            this.sshHostDsaKeyFingerprint = sshHostDsaKeyFingerprint;
            return this;
        }

        public final void setSshHostDsaKeyFingerprint(String sshHostDsaKeyFingerprint) {
            this.sshHostDsaKeyFingerprint = sshHostDsaKeyFingerprint;
        }

        public final String getSshHostRsaKeyFingerprint() {
            return this.sshHostRsaKeyFingerprint;
        }

        @Override
        public final Builder sshHostRsaKeyFingerprint(String sshHostRsaKeyFingerprint) {
            this.sshHostRsaKeyFingerprint = sshHostRsaKeyFingerprint;
            return this;
        }

        public final void setSshHostRsaKeyFingerprint(String sshHostRsaKeyFingerprint) {
            this.sshHostRsaKeyFingerprint = sshHostRsaKeyFingerprint;
        }

        public final String getSshKeyName() {
            return this.sshKeyName;
        }

        @Override
        public final Builder sshKeyName(String sshKeyName) {
            this.sshKeyName = sshKeyName;
            return this;
        }

        public final void setSshKeyName(String sshKeyName) {
            this.sshKeyName = sshKeyName;
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getTenancy() {
            return this.tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        public final String getVirtualizationType() {
            return this.virtualizationType;
        }

        @Override
        public final Builder virtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
            return this;
        }

        @Override
        public final Builder virtualizationType(VirtualizationType virtualizationType) {
            this.virtualizationType(virtualizationType.toString());
            return this;
        }

        public final void setVirtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
        }

        public Instance build() {
            return new Instance(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Instance> {
        public Builder agentVersion(String var1);

        public Builder amiId(String var1);

        public Builder architecture(String var1);

        public Builder architecture(Architecture var1);

        public Builder arn(String var1);

        public Builder autoScalingType(String var1);

        public Builder autoScalingType(AutoScalingType var1);

        public Builder availabilityZone(String var1);

        public Builder blockDeviceMappings(Collection<BlockDeviceMapping> var1);

        public Builder blockDeviceMappings(BlockDeviceMapping ... var1);

        public Builder createdAt(String var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder ec2InstanceId(String var1);

        public Builder ecsClusterArn(String var1);

        public Builder ecsContainerInstanceArn(String var1);

        public Builder elasticIp(String var1);

        public Builder hostname(String var1);

        public Builder infrastructureClass(String var1);

        public Builder installUpdatesOnBoot(Boolean var1);

        public Builder instanceId(String var1);

        public Builder instanceProfileArn(String var1);

        public Builder instanceType(String var1);

        public Builder lastServiceErrorId(String var1);

        public Builder layerIds(Collection<String> var1);

        public Builder layerIds(String ... var1);

        public Builder os(String var1);

        public Builder platform(String var1);

        public Builder privateDns(String var1);

        public Builder privateIp(String var1);

        public Builder publicDns(String var1);

        public Builder publicIp(String var1);

        public Builder registeredBy(String var1);

        public Builder reportedAgentVersion(String var1);

        public Builder reportedOs(ReportedOs var1);

        default public Builder reportedOs(Consumer<ReportedOs.Builder> reportedOs) {
            return this.reportedOs((ReportedOs)((ReportedOs.Builder)ReportedOs.builder().apply(reportedOs)).build());
        }

        public Builder rootDeviceType(String var1);

        public Builder rootDeviceType(RootDeviceType var1);

        public Builder rootDeviceVolumeId(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder sshHostDsaKeyFingerprint(String var1);

        public Builder sshHostRsaKeyFingerprint(String var1);

        public Builder sshKeyName(String var1);

        public Builder stackId(String var1);

        public Builder status(String var1);

        public Builder subnetId(String var1);

        public Builder tenancy(String var1);

        public Builder virtualizationType(String var1);

        public Builder virtualizationType(VirtualizationType var1);
    }
}

