/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.opsworks.model.OpsWorksResponse;
import software.amazon.awssdk.services.opsworks.model.RdsDbInstance;
import software.amazon.awssdk.services.opsworks.model.RdsDbInstancesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeRdsDbInstancesResponse
extends OpsWorksResponse
implements ToCopyableBuilder<Builder, DescribeRdsDbInstancesResponse> {
    private final List<RdsDbInstance> rdsDbInstances;

    private DescribeRdsDbInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.rdsDbInstances = builder.rdsDbInstances;
    }

    public List<RdsDbInstance> rdsDbInstances() {
        return this.rdsDbInstances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rdsDbInstances());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRdsDbInstancesResponse)) {
            return false;
        }
        DescribeRdsDbInstancesResponse other = (DescribeRdsDbInstancesResponse)((Object)obj);
        return Objects.equals(this.rdsDbInstances(), other.rdsDbInstances());
    }

    public String toString() {
        return ToString.builder((String)"DescribeRdsDbInstancesResponse").add("RdsDbInstances", this.rdsDbInstances()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RdsDbInstances": {
                return Optional.of(clazz.cast(this.rdsDbInstances()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksResponse.BuilderImpl
    implements Builder {
        private List<RdsDbInstance> rdsDbInstances;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRdsDbInstancesResponse model) {
            this.rdsDbInstances(model.rdsDbInstances);
        }

        public final Collection<RdsDbInstance.Builder> getRdsDbInstances() {
            return this.rdsDbInstances != null ? (Collection)this.rdsDbInstances.stream().map(RdsDbInstance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rdsDbInstances(Collection<RdsDbInstance> rdsDbInstances) {
            this.rdsDbInstances = RdsDbInstancesCopier.copy(rdsDbInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rdsDbInstances(RdsDbInstance ... rdsDbInstances) {
            this.rdsDbInstances(Arrays.asList(rdsDbInstances));
            return this;
        }

        public final void setRdsDbInstances(Collection<RdsDbInstance.BuilderImpl> rdsDbInstances) {
            this.rdsDbInstances = RdsDbInstancesCopier.copyFromBuilder(rdsDbInstances);
        }

        @Override
        public DescribeRdsDbInstancesResponse build() {
            return new DescribeRdsDbInstancesResponse(this);
        }
    }

    public static interface Builder
    extends OpsWorksResponse.Builder,
    CopyableBuilder<Builder, DescribeRdsDbInstancesResponse> {
        public Builder rdsDbInstances(Collection<RdsDbInstance> var1);

        public Builder rdsDbInstances(RdsDbInstance ... var1);
    }
}

