/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.DeploymentCommandArgsCopier;
import software.amazon.awssdk.services.opsworks.model.DeploymentCommandName;
import software.amazon.awssdk.services.opsworks.transform.DeploymentCommandMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeploymentCommand
implements StructuredPojo,
ToCopyableBuilder<Builder, DeploymentCommand> {
    private final String name;
    private final Map<String, List<String>> args;

    private DeploymentCommand(BuilderImpl builder) {
        this.name = builder.name;
        this.args = builder.args;
    }

    public DeploymentCommandName name() {
        return DeploymentCommandName.fromValue(this.name);
    }

    public String nameString() {
        return this.name;
    }

    public Map<String, List<String>> args() {
        return this.args;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nameString());
        hashCode = 31 * hashCode + Objects.hashCode(this.args());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentCommand)) {
            return false;
        }
        DeploymentCommand other = (DeploymentCommand)obj;
        return Objects.equals(this.nameString(), other.nameString()) && Objects.equals(this.args(), other.args());
    }

    public String toString() {
        return ToString.builder((String)"DeploymentCommand").add("Name", (Object)this.nameString()).add("Args", this.args()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.nameString()));
            }
            case "Args": {
                return Optional.of(clazz.cast(this.args()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeploymentCommandMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Map<String, List<String>> args;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentCommand model) {
            this.name(model.name);
            this.args(model.args);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(DeploymentCommandName name) {
            this.name(name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Map<String, ? extends Collection<String>> getArgs() {
            return this.args;
        }

        @Override
        public final Builder args(Map<String, ? extends Collection<String>> args) {
            this.args = DeploymentCommandArgsCopier.copy(args);
            return this;
        }

        public final void setArgs(Map<String, ? extends Collection<String>> args) {
            this.args = DeploymentCommandArgsCopier.copy(args);
        }

        public DeploymentCommand build() {
            return new DeploymentCommand(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeploymentCommand> {
        public Builder name(String var1);

        public Builder name(DeploymentCommandName var1);

        public Builder args(Map<String, ? extends Collection<String>> var1);
    }
}

