/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.SslConfiguration;

@SdkInternalApi
public class SslConfigurationMarshaller {
    private static final MarshallingInfo<String> CERTIFICATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Certificate").build();
    private static final MarshallingInfo<String> PRIVATEKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrivateKey").build();
    private static final MarshallingInfo<String> CHAIN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Chain").build();
    private static final SslConfigurationMarshaller INSTANCE = new SslConfigurationMarshaller();

    public static SslConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SslConfiguration sslConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (sslConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)sslConfiguration.certificate(), CERTIFICATE_BINDING);
            protocolMarshaller.marshall((Object)sslConfiguration.privateKey(), PRIVATEKEY_BINDING);
            protocolMarshaller.marshall((Object)sslConfiguration.chain(), CHAIN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

