/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.opsworks.model.App;
import software.amazon.awssdk.services.opsworks.transform.DataSourceUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.EnvironmentVariableUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.SourceUnmarshaller;
import software.amazon.awssdk.services.opsworks.transform.SslConfigurationUnmarshaller;

public class AppUnmarshaller
implements Unmarshaller<App, JsonUnmarshallerContext> {
    private static final AppUnmarshaller INSTANCE = new AppUnmarshaller();

    public App unmarshall(JsonUnmarshallerContext context) throws Exception {
        App.Builder appBuilder = App.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("AppId", targetDepth)) {
                    context.nextToken();
                    appBuilder.appId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("StackId", targetDepth)) {
                    context.nextToken();
                    appBuilder.stackId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Shortname", targetDepth)) {
                    context.nextToken();
                    appBuilder.shortname((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    appBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    appBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DataSources", targetDepth)) {
                    context.nextToken();
                    appBuilder.dataSources(new ListUnmarshaller((Unmarshaller)DataSourceUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("Type", targetDepth)) {
                    context.nextToken();
                    appBuilder.type((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("AppSource", targetDepth)) {
                    context.nextToken();
                    appBuilder.appSource(SourceUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Domains", targetDepth)) {
                    context.nextToken();
                    appBuilder.domains(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("EnableSsl", targetDepth)) {
                    context.nextToken();
                    appBuilder.enableSsl((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("SslConfiguration", targetDepth)) {
                    context.nextToken();
                    appBuilder.sslConfiguration(SslConfigurationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Attributes", targetDepth)) {
                    context.nextToken();
                    appBuilder.attributes(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("CreatedAt", targetDepth)) {
                    context.nextToken();
                    appBuilder.createdAt((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Environment", targetDepth)) {
                    context.nextToken();
                    appBuilder.environment(new ListUnmarshaller((Unmarshaller)EnvironmentVariableUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (App)appBuilder.build();
    }

    public static AppUnmarshaller getInstance() {
        return INSTANCE;
    }
}

