/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.WeeklyAutoScalingSchedule;
import software.amazon.awssdk.services.opsworks.transform.TimeBasedAutoScalingConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TimeBasedAutoScalingConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, TimeBasedAutoScalingConfiguration> {
    private final String instanceId;
    private final WeeklyAutoScalingSchedule autoScalingSchedule;

    private TimeBasedAutoScalingConfiguration(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.autoScalingSchedule = builder.autoScalingSchedule;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public WeeklyAutoScalingSchedule autoScalingSchedule() {
        return this.autoScalingSchedule;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingSchedule());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeBasedAutoScalingConfiguration)) {
            return false;
        }
        TimeBasedAutoScalingConfiguration other = (TimeBasedAutoScalingConfiguration)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.autoScalingSchedule(), other.autoScalingSchedule());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.autoScalingSchedule() != null) {
            sb.append("AutoScalingSchedule: ").append(this.autoScalingSchedule()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "AutoScalingSchedule": {
                return Optional.of(clazz.cast(this.autoScalingSchedule()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TimeBasedAutoScalingConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private WeeklyAutoScalingSchedule autoScalingSchedule;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeBasedAutoScalingConfiguration model) {
            this.instanceId(model.instanceId);
            this.autoScalingSchedule(model.autoScalingSchedule);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final WeeklyAutoScalingSchedule.Builder getAutoScalingSchedule() {
            return this.autoScalingSchedule != null ? this.autoScalingSchedule.toBuilder() : null;
        }

        @Override
        public final Builder autoScalingSchedule(WeeklyAutoScalingSchedule autoScalingSchedule) {
            this.autoScalingSchedule = autoScalingSchedule;
            return this;
        }

        public final void setAutoScalingSchedule(WeeklyAutoScalingSchedule.BuilderImpl autoScalingSchedule) {
            this.autoScalingSchedule = autoScalingSchedule != null ? autoScalingSchedule.build() : null;
        }

        public TimeBasedAutoScalingConfiguration build() {
            return new TimeBasedAutoScalingConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TimeBasedAutoScalingConfiguration> {
        public Builder instanceId(String var1);

        public Builder autoScalingSchedule(WeeklyAutoScalingSchedule var1);

        default public Builder autoScalingSchedule(Consumer<WeeklyAutoScalingSchedule.Builder> autoScalingSchedule) {
            return this.autoScalingSchedule((WeeklyAutoScalingSchedule)((WeeklyAutoScalingSchedule.Builder)WeeklyAutoScalingSchedule.builder().apply(autoScalingSchedule)).build());
        }
    }
}

