/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.InstancesCount;
import software.amazon.awssdk.services.opsworks.transform.StackSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StackSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, StackSummary> {
    private final String stackId;
    private final String name;
    private final String arn;
    private final Integer layersCount;
    private final Integer appsCount;
    private final InstancesCount instancesCount;

    private StackSummary(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.name = builder.name;
        this.arn = builder.arn;
        this.layersCount = builder.layersCount;
        this.appsCount = builder.appsCount;
        this.instancesCount = builder.instancesCount;
    }

    public String stackId() {
        return this.stackId;
    }

    public String name() {
        return this.name;
    }

    public String arn() {
        return this.arn;
    }

    public Integer layersCount() {
        return this.layersCount;
    }

    public Integer appsCount() {
        return this.appsCount;
    }

    public InstancesCount instancesCount() {
        return this.instancesCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.layersCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.appsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackSummary)) {
            return false;
        }
        StackSummary other = (StackSummary)obj;
        return Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.layersCount(), other.layersCount()) && Objects.equals(this.appsCount(), other.appsCount()) && Objects.equals(this.instancesCount(), other.instancesCount());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.stackId() != null) {
            sb.append("StackId: ").append(this.stackId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.layersCount() != null) {
            sb.append("LayersCount: ").append(this.layersCount()).append(",");
        }
        if (this.appsCount() != null) {
            sb.append("AppsCount: ").append(this.appsCount()).append(",");
        }
        if (this.instancesCount() != null) {
            sb.append("InstancesCount: ").append(this.instancesCount()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.of(clazz.cast(this.stackId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "LayersCount": {
                return Optional.of(clazz.cast(this.layersCount()));
            }
            case "AppsCount": {
                return Optional.of(clazz.cast(this.appsCount()));
            }
            case "InstancesCount": {
                return Optional.of(clazz.cast(this.instancesCount()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StackSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String stackId;
        private String name;
        private String arn;
        private Integer layersCount;
        private Integer appsCount;
        private InstancesCount instancesCount;

        private BuilderImpl() {
        }

        private BuilderImpl(StackSummary model) {
            this.stackId(model.stackId);
            this.name(model.name);
            this.arn(model.arn);
            this.layersCount(model.layersCount);
            this.appsCount(model.appsCount);
            this.instancesCount(model.instancesCount);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Integer getLayersCount() {
            return this.layersCount;
        }

        @Override
        public final Builder layersCount(Integer layersCount) {
            this.layersCount = layersCount;
            return this;
        }

        public final void setLayersCount(Integer layersCount) {
            this.layersCount = layersCount;
        }

        public final Integer getAppsCount() {
            return this.appsCount;
        }

        @Override
        public final Builder appsCount(Integer appsCount) {
            this.appsCount = appsCount;
            return this;
        }

        public final void setAppsCount(Integer appsCount) {
            this.appsCount = appsCount;
        }

        public final InstancesCount.Builder getInstancesCount() {
            return this.instancesCount != null ? this.instancesCount.toBuilder() : null;
        }

        @Override
        public final Builder instancesCount(InstancesCount instancesCount) {
            this.instancesCount = instancesCount;
            return this;
        }

        public final void setInstancesCount(InstancesCount.BuilderImpl instancesCount) {
            this.instancesCount = instancesCount != null ? instancesCount.build() : null;
        }

        public StackSummary build() {
            return new StackSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StackSummary> {
        public Builder stackId(String var1);

        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder layersCount(Integer var1);

        public Builder appsCount(Integer var1);

        public Builder instancesCount(InstancesCount var1);

        default public Builder instancesCount(Consumer<InstancesCount.Builder> instancesCount) {
            return this.instancesCount((InstancesCount)((InstancesCount.Builder)InstancesCount.builder().apply(instancesCount)).build());
        }
    }
}

