/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.opsworks.model.OpsWorksResponse;
import software.amazon.awssdk.services.opsworks.model.TagsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListTagsResponse
extends OpsWorksResponse
implements ToCopyableBuilder<Builder, ListTagsResponse> {
    private final Map<String, String> tags;
    private final String nextToken;

    private ListTagsResponse(BuilderImpl builder) {
        super(builder);
        this.tags = builder.tags;
        this.nextToken = builder.nextToken;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsResponse)) {
            return false;
        }
        ListTagsResponse other = (ListTagsResponse)((Object)obj);
        return Objects.equals(this.tags(), other.tags()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksResponse.BuilderImpl
    implements Builder {
        private Map<String, String> tags;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsResponse model) {
            this.tags(model.tags);
            this.nextToken(model.nextToken);
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTagsResponse build() {
            return new ListTagsResponse(this);
        }
    }

    public static interface Builder
    extends OpsWorksResponse.Builder,
    CopyableBuilder<Builder, ListTagsResponse> {
        public Builder tags(Map<String, String> var1);

        public Builder nextToken(String var1);
    }
}

