/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.opsworks.model.OpsWorksResponse;
import software.amazon.awssdk.services.opsworks.model.UserProfile;
import software.amazon.awssdk.services.opsworks.model.UserProfilesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeUserProfilesResponse
extends OpsWorksResponse
implements ToCopyableBuilder<Builder, DescribeUserProfilesResponse> {
    private final List<UserProfile> userProfiles;

    private DescribeUserProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.userProfiles = builder.userProfiles;
    }

    public List<UserProfile> userProfiles() {
        return this.userProfiles;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userProfiles());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserProfilesResponse)) {
            return false;
        }
        DescribeUserProfilesResponse other = (DescribeUserProfilesResponse)((Object)obj);
        return Objects.equals(this.userProfiles(), other.userProfiles());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.userProfiles() != null) {
            sb.append("UserProfiles: ").append(this.userProfiles()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserProfiles": {
                return Optional.of(clazz.cast(this.userProfiles()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksResponse.BuilderImpl
    implements Builder {
        private List<UserProfile> userProfiles;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserProfilesResponse model) {
            this.userProfiles(model.userProfiles);
        }

        public final Collection<UserProfile.Builder> getUserProfiles() {
            return this.userProfiles != null ? (Collection)this.userProfiles.stream().map(UserProfile::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userProfiles(Collection<UserProfile> userProfiles) {
            this.userProfiles = UserProfilesCopier.copy(userProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userProfiles(UserProfile ... userProfiles) {
            this.userProfiles(Arrays.asList(userProfiles));
            return this;
        }

        public final void setUserProfiles(Collection<UserProfile.BuilderImpl> userProfiles) {
            this.userProfiles = UserProfilesCopier.copyFromBuilder(userProfiles);
        }

        @Override
        public DescribeUserProfilesResponse build() {
            return new DescribeUserProfilesResponse(this);
        }
    }

    public static interface Builder
    extends OpsWorksResponse.Builder,
    CopyableBuilder<Builder, DescribeUserProfilesResponse> {
        public Builder userProfiles(Collection<UserProfile> var1);

        public Builder userProfiles(UserProfile ... var1);
    }
}

