/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.opsworks.model.OpsWorksResponse;
import software.amazon.awssdk.services.opsworks.model.ServiceError;
import software.amazon.awssdk.services.opsworks.model.ServiceErrorsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeServiceErrorsResponse
extends OpsWorksResponse
implements ToCopyableBuilder<Builder, DescribeServiceErrorsResponse> {
    private final List<ServiceError> serviceErrors;

    private DescribeServiceErrorsResponse(BuilderImpl builder) {
        super(builder);
        this.serviceErrors = builder.serviceErrors;
    }

    public List<ServiceError> serviceErrors() {
        return this.serviceErrors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceErrors());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServiceErrorsResponse)) {
            return false;
        }
        DescribeServiceErrorsResponse other = (DescribeServiceErrorsResponse)((Object)obj);
        return Objects.equals(this.serviceErrors(), other.serviceErrors());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.serviceErrors() != null) {
            sb.append("ServiceErrors: ").append(this.serviceErrors()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceErrors": {
                return Optional.of(clazz.cast(this.serviceErrors()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksResponse.BuilderImpl
    implements Builder {
        private List<ServiceError> serviceErrors;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServiceErrorsResponse model) {
            this.serviceErrors(model.serviceErrors);
        }

        public final Collection<ServiceError.Builder> getServiceErrors() {
            return this.serviceErrors != null ? (Collection)this.serviceErrors.stream().map(ServiceError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serviceErrors(Collection<ServiceError> serviceErrors) {
            this.serviceErrors = ServiceErrorsCopier.copy(serviceErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceErrors(ServiceError ... serviceErrors) {
            this.serviceErrors(Arrays.asList(serviceErrors));
            return this;
        }

        public final void setServiceErrors(Collection<ServiceError.BuilderImpl> serviceErrors) {
            this.serviceErrors = ServiceErrorsCopier.copyFromBuilder(serviceErrors);
        }

        @Override
        public DescribeServiceErrorsResponse build() {
            return new DescribeServiceErrorsResponse(this);
        }
    }

    public static interface Builder
    extends OpsWorksResponse.Builder,
    CopyableBuilder<Builder, DescribeServiceErrorsResponse> {
        public Builder serviceErrors(Collection<ServiceError> var1);

        public Builder serviceErrors(ServiceError ... var1);
    }
}

