/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeElasticIpsRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, DescribeElasticIpsRequest> {
    private final String instanceId;
    private final String stackId;
    private final List<String> ips;

    private DescribeElasticIpsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.stackId = builder.stackId;
        this.ips = builder.ips;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String stackId() {
        return this.stackId;
    }

    public List<String> ips() {
        return this.ips;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ips());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticIpsRequest)) {
            return false;
        }
        DescribeElasticIpsRequest other = (DescribeElasticIpsRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.ips(), other.ips());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.stackId() != null) {
            sb.append("StackId: ").append(this.stackId()).append(",");
        }
        if (this.ips() != null) {
            sb.append("Ips: ").append(this.ips()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "StackId": {
                return Optional.of(clazz.cast(this.stackId()));
            }
            case "Ips": {
                return Optional.of(clazz.cast(this.ips()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String stackId;
        private List<String> ips;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticIpsRequest model) {
            this.instanceId(model.instanceId);
            this.stackId(model.stackId);
            this.ips(model.ips);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final Collection<String> getIps() {
            return this.ips;
        }

        @Override
        public final Builder ips(Collection<String> ips) {
            this.ips = StringsCopier.copy(ips);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ips(String ... ips) {
            this.ips(Arrays.asList(ips));
            return this;
        }

        public final void setIps(Collection<String> ips) {
            this.ips = StringsCopier.copy(ips);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeElasticIpsRequest build() {
            return new DescribeElasticIpsRequest(this);
        }
    }

    public static interface Builder
    extends OpsWorksRequest.Builder,
    CopyableBuilder<Builder, DescribeElasticIpsRequest> {
        public Builder instanceId(String var1);

        public Builder stackId(String var1);

        public Builder ips(Collection<String> var1);

        public Builder ips(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

