/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.ElasticLoadBalancer;

@SdkInternalApi
public class ElasticLoadBalancerMarshaller {
    private static final MarshallingInfo<String> ELASTICLOADBALANCERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ElasticLoadBalancerName").build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Region").build();
    private static final MarshallingInfo<String> DNSNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DnsName").build();
    private static final MarshallingInfo<String> STACKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StackId").build();
    private static final MarshallingInfo<String> LAYERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LayerId").build();
    private static final MarshallingInfo<String> VPCID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VpcId").build();
    private static final MarshallingInfo<List> AVAILABILITYZONES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AvailabilityZones").build();
    private static final MarshallingInfo<List> SUBNETIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetIds").build();
    private static final MarshallingInfo<List> EC2INSTANCEIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ec2InstanceIds").build();
    private static final ElasticLoadBalancerMarshaller INSTANCE = new ElasticLoadBalancerMarshaller();

    public static ElasticLoadBalancerMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ElasticLoadBalancer elasticLoadBalancer, ProtocolMarshaller protocolMarshaller) {
        if (elasticLoadBalancer == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)elasticLoadBalancer.elasticLoadBalancerName(), ELASTICLOADBALANCERNAME_BINDING);
            protocolMarshaller.marshall((Object)elasticLoadBalancer.region(), REGION_BINDING);
            protocolMarshaller.marshall((Object)elasticLoadBalancer.dnsName(), DNSNAME_BINDING);
            protocolMarshaller.marshall((Object)elasticLoadBalancer.stackId(), STACKID_BINDING);
            protocolMarshaller.marshall((Object)elasticLoadBalancer.layerId(), LAYERID_BINDING);
            protocolMarshaller.marshall((Object)elasticLoadBalancer.vpcId(), VPCID_BINDING);
            protocolMarshaller.marshall(elasticLoadBalancer.availabilityZones(), AVAILABILITYZONES_BINDING);
            protocolMarshaller.marshall(elasticLoadBalancer.subnetIds(), SUBNETIDS_BINDING);
            protocolMarshaller.marshall(elasticLoadBalancer.ec2InstanceIds(), EC2INSTANCEIDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

