/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.ChefConfiguration;

@SdkInternalApi
public class ChefConfigurationMarshaller {
    private static final MarshallingInfo<Boolean> MANAGEBERKSHELF_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ManageBerkshelf").build();
    private static final MarshallingInfo<String> BERKSHELFVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BerkshelfVersion").build();
    private static final ChefConfigurationMarshaller INSTANCE = new ChefConfigurationMarshaller();

    public static ChefConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ChefConfiguration chefConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (chefConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)chefConfiguration.manageBerkshelf(), MANAGEBERKSHELF_BINDING);
            protocolMarshaller.marshall((Object)chefConfiguration.berkshelfVersion(), BERKSHELFVERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

